package com.zoyi.channel.plugin.android.activity.chat.view.attachment;

import android.content.Context;
import androidx.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.contentview.OnAttachmentContentActionListener;
import com.zoyi.channel.plugin.android.activity.chat.view.viewholder.MessageContentView;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.com.annimon.stream.Collectors;
import com.zoyi.com.annimon.stream.Stream;

import java.util.ArrayList;
import java.util.List;

public class AttachmentsLayout extends LinearLayout implements MessageContentView {

  private AttachmentGroupLinearLayout layoutAttachmentsGroupOrigin;
  private AttachmentGroupGridLayout layoutAttachmentsGroupGrid;
  private AttachmentGroupLinearLayout layoutAttachmentsGroupOthers;

  private int attachmentsMaxWidth;

  public AttachmentsLayout(Context context) {
    super(context);

    init(context);
  }

  public AttachmentsLayout(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init(context);
  }

  public AttachmentsLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);

    init(context);
  }

  private void init(Context context) {
    LayoutInflater.from(context).inflate(R.layout.ch_holder_item_layout_attachments, this);

    layoutAttachmentsGroupOrigin = findViewById(R.id.ch_layoutAttachmentsGroupOrigin);
    layoutAttachmentsGroupGrid = findViewById(R.id.ch_layoutAttachmentsGroupGrid);
    layoutAttachmentsGroupOthers = findViewById(R.id.ch_layoutAttachmentsGroupOthers);

    attachmentsMaxWidth = ResUtils.getDimen(context, R.dimen.ch_chat_message_attachments_max_width);
  }

  @Override
  public void setGravity(int gravity) {
    super.setGravity(gravity);

    layoutAttachmentsGroupOrigin.setGravity(gravity);
    layoutAttachmentsGroupOthers.setGravity(gravity);
  }

  public void setAttachments(@Nullable String messageId, @Nullable List<File> files, @Nullable OnAttachmentContentActionListener listener) {
    ArrayList<File> linearGroup = Stream.ofNullable(files).filter(File::isVideo).collect(Collectors.toCollection(ArrayList::new));
    ArrayList<File> gridGroup = Stream.ofNullable(files).filter(File::isImage).collect(Collectors.toCollection(ArrayList::new));
    ArrayList<File> otherGroup = Stream.ofNullable(files).filter(file -> !file.isVideo() && !file.isImage())
        .collect(Collectors.toCollection(ArrayList::new));

    // when grid group count is 1, it should show in origin ratio
    if (gridGroup.size() == 1) {
      linearGroup.addAll(gridGroup);
      gridGroup.clear();
    }

    layoutAttachmentsGroupOrigin.setAttachments(messageId, linearGroup, listener);
    layoutAttachmentsGroupGrid.setAttachments(messageId, gridGroup, listener);
    layoutAttachmentsGroupOthers.setAttachments(messageId, otherGroup, listener);
  }

  @Override
  protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
    int width = MeasureSpec.getSize(widthMeasureSpec);
    int newWidthMeasureSpec = width > attachmentsMaxWidth
        ? MeasureSpec.makeMeasureSpec(attachmentsMaxWidth, MeasureSpec.EXACTLY)
        : widthMeasureSpec;

    super.onMeasure(newWidthMeasureSpec, heightMeasureSpec);
  }

  @Override
  public void resetView() {
    setVisibility(View.GONE);

    layoutAttachmentsGroupOrigin.resetView();
    layoutAttachmentsGroupGrid.resetView();
    layoutAttachmentsGroupOthers.resetView();
  }

  @Override
  public void clear() {
    layoutAttachmentsGroupOrigin.clear();
    layoutAttachmentsGroupGrid.clear();
    layoutAttachmentsGroupOthers.clear();
  }
}
