package com.zoyi.channel.plugin.android.activity.chat.utils;

import android.app.Activity;
import android.graphics.Rect;
import android.os.Build;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import android.view.*;
import android.view.inputmethod.InputMethodManager;

import com.zoyi.channel.plugin.android.activity.chat.ChatActivity;
import com.zoyi.channel.plugin.android.activity.chat2.ChatActivity2;
import com.zoyi.channel.plugin.android.util.Views;

public class KeyboardUtils {

  @Nullable
  @Deprecated
  private ChatActivity chatActivity;
  @Nullable
  private ChatActivity2 chatActivity2;
  private View decorView;
  private View contentView;
  private RecyclerView recyclerView;

  @Deprecated
  public KeyboardUtils(ChatActivity activity, View contentView, RecyclerView recyclerView) {
    this.chatActivity = activity;
    this.decorView = activity.getWindow().getDecorView();
    this.contentView = contentView;
    this.recyclerView = recyclerView;
  }

  public KeyboardUtils(ChatActivity2 activity, View contentView, RecyclerView recyclerView) {
    this.chatActivity2 = activity;
    this.decorView = activity.getWindow().getDecorView();
    this.contentView = contentView;
    this.recyclerView = recyclerView;
  }

  public void enable() {
    if (Views.isFullscreenSupporting()) {
      decorView.getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener);
    }
  }

  public void disable() {
    if (Views.isFullscreenSupporting()) {
      decorView.getViewTreeObserver().removeOnGlobalLayoutListener(onGlobalLayoutListener);
    }
  }

  private Rect getSystemWindowInsets() {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M &&
        decorView != null &&
        decorView.getRootWindowInsets() != null
    ) {
      WindowInsets rootWindowInsets = decorView.getRootWindowInsets();
      return new Rect(
          rootWindowInsets.getSystemWindowInsetLeft(),
          rootWindowInsets.getSystemWindowInsetTop(),
          rootWindowInsets.getSystemWindowInsetRight(),
          rootWindowInsets.getSystemWindowInsetBottom()
      );
    }
    return new Rect(0, 0, 0, 0);
  }

  private Rect getStableInsets() {
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M &&
        decorView != null &&
        decorView.getRootWindowInsets() != null
    ) {
      WindowInsets rootWindowInsets = decorView.getRootWindowInsets();
      return new Rect(
          rootWindowInsets.getStableInsetLeft(),
          rootWindowInsets.getStableInsetTop(),
          rootWindowInsets.getStableInsetRight(),
          rootWindowInsets.getStableInsetBottom()
      );
    }
    return new Rect(0, 0, 0, 0);
  }

  //a small helper to allow showing the editText focus
  private ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener() {
    @Override
    public void onGlobalLayout() {
      Rect systemInsets = getSystemWindowInsets();
      Rect stableInsets = getStableInsets();

      int diff = Math.max(0, systemInsets.bottom - stableInsets.bottom);

//      L.e("System: " + systemInsets.top + " " + systemInsets.right + " " + systemInsets.bottom + " " + systemInsets.left);
//      L.e("Stable: " + stableInsets.top + " " + stableInsets.right + " " + stableInsets.bottom + " " + stableInsets.left);
//      L.e("Result: " + diff);
//      L.e("#");

      //if it could be a keyboard add the padding to the view
      if (diff != 0) {
        // if the use-able screen height differs from the total screen height we assume that it shows a keyboard now
        //check if the padding is 0 (if yes set the padding for the keyboard)
        if (contentView.getPaddingBottom() != diff) {
          boolean isOnBottom = !recyclerView.canScrollVertically(1);
          //set the padding of the contentView for the keyboard
          contentView.setPadding(0, 0, 0, diff);

          if (isOnBottom) {
            if (chatActivity != null) {
              chatActivity.scrollToBottom();
            }
            if (chatActivity2 != null) {
              chatActivity2.scrollToBottom();
            }
          }
        }
      } else {
        //check if the padding is != 0 (if yes reset the padding)
        if (contentView.getPaddingBottom() != 0) {
          //reset the padding of the contentView
          contentView.setPadding(0, 0, 0, 0);
        }
      }
    }
  };


  /**
   * Helper to hide the keyboard
   *
   * @param activity
   */
  public static void hideKeyboard(Activity activity) {
    if (activity != null && activity.getCurrentFocus() != null) {
      InputMethodManager inputMethodManager = (InputMethodManager) activity.getSystemService(Activity.INPUT_METHOD_SERVICE);
      inputMethodManager.hideSoftInputFromWindow(activity.getCurrentFocus().getWindowToken(), 0);
    }
  }
}
