package com.zoyi.channel.plugin.android.activity.chat.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.zoyi.channel.plugin.android.activity.chat.type.ContentType;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.enumerate.SendingState;
import com.zoyi.channel.plugin.android.util.Utils;

public abstract class SendItem extends ConnectableMessageItem implements MessageItem {

  // chat id is null when you must create new chat
  @Nullable
  private String chatId;

  @NonNull
  protected String requestId;

  // only refresh when do resend action
  @NonNull
  protected Long createdAt;

  @NonNull
  protected SendingState state;

  protected SendItem(@Nullable String chatId) {
    this(chatId, 0);
  }

  protected SendItem(@Nullable String chatId, int index) {
    this.createdAt = System.currentTimeMillis() + index;
    this.requestId = generateRequestId();
    this.state = SendingState.WAITING;
    this.chatId = chatId;
  }

  // actions

  public void renew() {
    this.createdAt = System.currentTimeMillis();
    this.requestId = generateRequestId();
    this.state = SendingState.WAITING;
  }

  public void doFail() {
    this.state = SendingState.FAIL;
  }

  // getter / setter

  private String generateRequestId() {
    return this.createdAt + Utils.getRandomString(4);
  }

  @Override
  public String getSecondaryKey() {
    return requestId;
  }

  @NonNull
  public String getRequestId() {
    return requestId;
  }

  @NonNull
  @Override
  public Long getCreatedAt() {
    return createdAt;
  }

  @NonNull
  public SendingState getState() {
    return state;
  }

  @Nullable
  public String getChatId() {
    return chatId;
  }

  public void setChatId(@Nullable String chatId) {
    this.chatId = chatId;
  }

  // implements, abstract functions

  @Override
  public boolean isSamePerson(@Nullable Object item) {
    if (item instanceof SendItem) {
      return true;
    } else if (item instanceof ChatMessageItem) {
      return ((ChatMessageItem) item).getType() == MessageType.USER;
    }
    return false;
  }

  public abstract ContentType getContentType();

  public abstract boolean shouldShowTempMessage();

  @Override
  public boolean equals(@Nullable Object o) {
    if (o instanceof SendItem) {
      SendItem next = (SendItem) o;

      return this.requestId.equals(next.requestId);
    }
    return false;
  }
}
