package com.zoyi.channel.plugin.android;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;

import com.zoyi.channel.plugin.android.store.PopupStore;
import com.zoyi.channel.plugin.android.util.ContextUtils;
import com.zoyi.channel.plugin.android.view.listener.OnPopupClickListener;
import com.zoyi.channel.plugin.android.selector.GlobalSelector;
import com.zoyi.channel.plugin.android.selector.PopupSelector;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.popup.BubblePopupView;
import com.zoyi.channel.plugin.android.view.popup.FullScreenPopupView;

/**
 * Control launcher, popup
 */
class ChannelView extends FrameLayout implements OnPopupClickListener {

  private Context context;

  private ChannelLauncherView launcherView;
  private FullScreenPopupView viewPopupFullScreen;
  private BubblePopupView viewPopupBubble;

  @Nullable
  private Binder visibilityBinder;

  @Nullable
  private Binder launcherVisibilityBinder;

  @Nullable
  private Binder popupBinder;

  public ChannelView(Context context) {
    super(context);
    init(context);
  }

  public ChannelView(Context context, AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public ChannelView(Context context, AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  @Initializer
  private void init(Context context) {
    this.context = context;

    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_layout_channel_view, this, true);

    launcherView = view.findViewById(R.id.ch_viewLauncher);

    viewPopupBubble = view.findViewById(R.id.ch_viewPopupBubble);
    viewPopupBubble.setPopupClickListener(this);

    viewPopupFullScreen = view.findViewById(R.id.ch_viewPopupFullScreen);
    viewPopupFullScreen.setPopupClickListener(this);
  }

  @Override
  protected void onAttachedToWindow() {
    super.onAttachedToWindow();

    visibilityBinder = GlobalSelector.bindBootState(booted -> setVisibility(booted ? View.VISIBLE : View.GONE));

    launcherVisibilityBinder = GlobalSelector.bindLauncherVisibility(showLauncher -> {
      if (showLauncher) {
        launcherView.show();
      } else {
        launcherView.hide();
      }
    });

    popupBinder = PopupSelector.bindPopup(message -> {
      if (message != null) {
        if (message.getMarketing() != null && message.getMarketing().isFullScreen()) {
          viewPopupBubble.resetView();
          viewPopupFullScreen.show(message);
        } else {
          viewPopupFullScreen.resetView();
          viewPopupBubble.show(message);
        }
      } else {
        viewPopupFullScreen.resetView();
        viewPopupBubble.resetView();
      }
    });
  }

  @Override
  protected void onDetachedFromWindow() {
    super.onDetachedFromWindow();

    if (visibilityBinder != null) {
      visibilityBinder.unbind();
    }

    if (launcherVisibilityBinder != null) {
      launcherVisibilityBinder.unbind();
    }

    if (popupBinder != null) {
      popupBinder.unbind();
    }
  }

  @Override
  public void onPopupClick(@NonNull String chatId) {
    PopupStore.get().popupMessage.set(null);
    Activity activity = ContextUtils.getActivity(context);

    if (activity != null) {
      ChannelIO.openChat((Activity) context, chatId, null);
    }
  }
}
