/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.youtube.player;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.webkit.JavascriptInterface;
import com.zoyi.channel.plugin.android.view.youtube.player.PlayerConstants;
import com.zoyi.channel.plugin.android.view.youtube.player.YouTubePlayer;
import com.zoyi.channel.plugin.android.view.youtube.player.listener.YouTubePlayerListener;
import java.util.Collection;

public class YouTubePlayerBridge {
    private static final String STATE_UNSTARTED = "UNSTARTED";
    private static final String STATE_ENDED = "ENDED";
    private static final String STATE_PLAYING = "PLAYING";
    private static final String STATE_PAUSED = "PAUSED";
    private static final String STATE_BUFFERING = "BUFFERING";
    private static final String STATE_CUED = "CUED";
    private static final String QUALITY_SMALL = "small";
    private static final String QUALITY_MEDIUM = "medium";
    private static final String QUALITY_LARGE = "large";
    private static final String QUALITY_HD720 = "hd720";
    private static final String QUALITY_HD1080 = "hd1080";
    private static final String QUALITY_HIGH_RES = "highres";
    private static final String QUALITY_DEFAULT = "default";
    private static final String RATE_0_25 = "0.25";
    private static final String RATE_0_5 = "0.5";
    private static final String RATE_1 = "1";
    private static final String RATE_1_5 = "1.5";
    private static final String RATE_2 = "2";
    private static final String ERROR_INVALID_PARAMETER_IN_REQUEST = "2";
    private static final String ERROR_HTML_5_PLAYER = "5";
    private static final String ERROR_VIDEO_NOT_FOUND = "100";
    private static final String ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER1 = "101";
    private static final String ERROR_VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER2 = "150";
    private YouTubePlayerBridgeCallbacks youTubePlayerOwner;
    private Handler mainThreadHandler = new Handler(Looper.getMainLooper());

    public YouTubePlayerBridge(YouTubePlayerBridgeCallbacks youTubePlayerOwner) {
        this.youTubePlayerOwner = youTubePlayerOwner;
    }

    @JavascriptInterface
    public void sendYouTubeIFrameAPIReady() {
        this.mainThreadHandler.post(() -> this.youTubePlayerOwner.onYouTubeIFrameAPIReady());
    }

    @JavascriptInterface
    public void sendReady() {
        this.mainThreadHandler.post(() -> {
            for (YouTubePlayerListener listener : this.youTubePlayerOwner.getListeners()) {
                listener.onReady(this.youTubePlayerOwner.getInstance());
            }
        });
    }

    @JavascriptInterface
    public void sendStateChange(String state) {
        PlayerConstants.PlayerState playerState = this.parsePlayerState(state);
        this.mainThreadHandler.post(() -> {
            for (YouTubePlayerListener listener : this.youTubePlayerOwner.getListeners()) {
                listener.onStateChange(this.youTubePlayerOwner.getInstance(), playerState);
            }
        });
    }

    @JavascriptInterface
    public void sendPlaybackQualityChange(String quality) {
        PlayerConstants.PlaybackQuality playbackQuality = this.parsePlaybackQuality(quality);
        this.mainThreadHandler.post(() -> {
            for (YouTubePlayerListener listener : this.youTubePlayerOwner.getListeners()) {
                listener.onPlaybackQualityChange(this.youTubePlayerOwner.getInstance(), playbackQuality);
            }
        });
    }

    @JavascriptInterface
    public void sendPlaybackRateChange(String rate) {
        PlayerConstants.PlaybackRate playbackRate = this.parsePlaybackRate(rate);
        this.mainThreadHandler.post(() -> {
            for (YouTubePlayerListener listener : this.youTubePlayerOwner.getListeners()) {
                listener.onPlaybackRateChange(this.youTubePlayerOwner.getInstance(), playbackRate);
            }
        });
    }

    @JavascriptInterface
    public void sendError(String error) {
        PlayerConstants.PlayerError playerError = this.parsePlayerError(error);
        this.mainThreadHandler.post(() -> {
            for (YouTubePlayerListener listener : this.youTubePlayerOwner.getListeners()) {
                listener.onError(this.youTubePlayerOwner.getInstance(), playerError);
            }
        });
    }

    @JavascriptInterface
    public void sendApiChange() {
        this.mainThreadHandler.post(() -> {
            for (YouTubePlayerListener listener : this.youTubePlayerOwner.getListeners()) {
                listener.onApiChange(this.youTubePlayerOwner.getInstance());
            }
        });
    }

    @JavascriptInterface
    public void sendVideoCurrentTime(String seconds) {
        float currentTimeSeconds;
        try {
            currentTimeSeconds = Float.valueOf(seconds).floatValue();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return;
        }
        this.mainThreadHandler.post(() -> {
            for (YouTubePlayerListener listener : this.youTubePlayerOwner.getListeners()) {
                listener.onCurrentSecond(this.youTubePlayerOwner.getInstance(), currentTimeSeconds);
            }
        });
    }

    @JavascriptInterface
    public void sendVideoDuration(String seconds) {
        float videoDuration;
        try {
            String finalSeconds = TextUtils.isEmpty((CharSequence)seconds) ? "0" : seconds;
            videoDuration = Float.valueOf(finalSeconds).floatValue();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return;
        }
        this.mainThreadHandler.post(() -> {
            for (YouTubePlayerListener listener : this.youTubePlayerOwner.getListeners()) {
                listener.onVideoDuration(this.youTubePlayerOwner.getInstance(), videoDuration);
            }
        });
    }

    @JavascriptInterface
    public void sendVideoLoadedFraction(String fraction) {
        float loadedFraction;
        try {
            loadedFraction = Float.valueOf(fraction).floatValue();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return;
        }
        this.mainThreadHandler.post(() -> {
            for (YouTubePlayerListener listener : this.youTubePlayerOwner.getListeners()) {
                listener.onVideoLoadedFraction(this.youTubePlayerOwner.getInstance(), loadedFraction);
            }
        });
    }

    @JavascriptInterface
    public void sendVideoId(String videoId) {
        this.mainThreadHandler.post(() -> {
            for (YouTubePlayerListener listener : this.youTubePlayerOwner.getListeners()) {
                listener.onVideoId(this.youTubePlayerOwner.getInstance(), videoId);
            }
        });
    }

    private PlayerConstants.PlayerState parsePlayerState(String state) {
        switch (state) {
            case "UNSTARTED": {
                return PlayerConstants.PlayerState.UNSTARTED;
            }
            case "ENDED": {
                return PlayerConstants.PlayerState.ENDED;
            }
            case "PLAYING": {
                return PlayerConstants.PlayerState.PLAYING;
            }
            case "PAUSED": {
                return PlayerConstants.PlayerState.PAUSED;
            }
            case "BUFFERING": {
                return PlayerConstants.PlayerState.BUFFERING;
            }
            case "CUED": {
                return PlayerConstants.PlayerState.VIDEO_CUED;
            }
        }
        return PlayerConstants.PlayerState.UNKNOWN;
    }

    private PlayerConstants.PlaybackQuality parsePlaybackQuality(String quality) {
        switch (quality) {
            case "small": {
                return PlayerConstants.PlaybackQuality.SMALL;
            }
            case "medium": {
                return PlayerConstants.PlaybackQuality.MEDIUM;
            }
            case "large": {
                return PlayerConstants.PlaybackQuality.LARGE;
            }
            case "hd720": {
                return PlayerConstants.PlaybackQuality.HD720;
            }
            case "hd1080": {
                return PlayerConstants.PlaybackQuality.HD1080;
            }
            case "highres": {
                return PlayerConstants.PlaybackQuality.HIGH_RES;
            }
            case "default": {
                return PlayerConstants.PlaybackQuality.DEFAULT;
            }
        }
        return PlayerConstants.PlaybackQuality.UNKNOWN;
    }

    private PlayerConstants.PlaybackRate parsePlaybackRate(String rate) {
        switch (rate) {
            case "0.25": {
                return PlayerConstants.PlaybackRate.RATE_0_25;
            }
            case "0.5": {
                return PlayerConstants.PlaybackRate.RATE_0_5;
            }
            case "1": {
                return PlayerConstants.PlaybackRate.RATE_1;
            }
            case "1.5": {
                return PlayerConstants.PlaybackRate.RATE_1_5;
            }
            case "2": {
                return PlayerConstants.PlaybackRate.RATE_2;
            }
        }
        return PlayerConstants.PlaybackRate.UNKNOWN;
    }

    private PlayerConstants.PlayerError parsePlayerError(String error) {
        switch (error) {
            case "2": {
                return PlayerConstants.PlayerError.INVALID_PARAMETER_IN_REQUEST;
            }
            case "5": {
                return PlayerConstants.PlayerError.HTML_5_PLAYER;
            }
            case "100": {
                return PlayerConstants.PlayerError.VIDEO_NOT_FOUND;
            }
            case "101": 
            case "150": {
                return PlayerConstants.PlayerError.VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER;
            }
        }
        return PlayerConstants.PlayerError.UNKNOWN;
    }

    public static interface YouTubePlayerBridgeCallbacks {
        public YouTubePlayer getInstance();

        public Collection<YouTubePlayerListener> getListeners();

        public void onYouTubeIFrameAPIReady();
    }
}

