/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Activity;
import android.app.Application;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.ProcessLifecycleOwner;
import android.content.Context;
import android.os.Looper;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.ActivityInterceptor;
import com.zoyi.channel.plugin.android.ChannelActionHandler;
import com.zoyi.channel.plugin.android.action.BootAction;
import com.zoyi.channel.plugin.android.action.ChatAction;
import com.zoyi.channel.plugin.android.action.EventAction;
import com.zoyi.channel.plugin.android.activity.chat.manager.ChatManager;
import com.zoyi.channel.plugin.android.activity.lounge.LoungeActivity;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.global.LifecycleController;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.manager.ChatVideoManager;
import com.zoyi.channel.plugin.android.model.repo.PluginRepo;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.open.callback.BootCallback;
import com.zoyi.channel.plugin.android.open.config.BootConfig;
import com.zoyi.channel.plugin.android.open.enumerate.BootStatus;
import com.zoyi.channel.plugin.android.open.listener.ChannelPluginListener;
import com.zoyi.channel.plugin.android.push.ChannelPushManager;
import com.zoyi.channel.plugin.android.selector.GlobalSelector;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.store.GlobalStore;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.channel.plugin.android.store.TimerStore;
import com.zoyi.channel.plugin.android.store.base.Store;
import com.zoyi.channel.plugin.android.util.BootManager;
import com.zoyi.channel.plugin.android.util.IntentUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.com.annimon.stream.Optional;
import java.util.concurrent.RejectedExecutionException;

class RealChannelIO {
    private Application application;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private ChannelActionHandler handler;
    private ActivityInterceptor activityInterceptor;
    private LifecycleController lifecycleController;

    RealChannelIO(Application application) {
        this.application = application;
        this.uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        this.handler = new ChannelActionHandler();
        SocketManager.create(application);
        this.activityInterceptor = new ActivityInterceptor();
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityInterceptor);
        this.lifecycleController = new LifecycleController();
        ProcessLifecycleOwner.get().getLifecycle().addObserver((LifecycleObserver)this.lifecycleController);
        Thread.setDefaultUncaughtExceptionHandler((thread, ex) -> {
            if (this.uncaughtExceptionHandler != null) {
                this.uncaughtExceptionHandler.uncaughtException(thread, ex);
            }
            if (!SocketManager.isReady() && Looper.getMainLooper().getThread() != thread && ex instanceof RejectedExecutionException) {
                SocketManager.reconnect();
            }
        });
    }

    Application getApplication() {
        return this.application;
    }

    void boot(final BootConfig bootConfig, final @Nullable BootCallback bootCallback) {
        this.shutdown();
        BootAction.boot(bootConfig, bootCallback, new RestSubscriber<PluginRepo>(){

            @Override
            public void onError(RetrofitException e) {
                BootManager.sendNetworkError(bootCallback, e);
            }

            @Override
            public void onNext(PluginRepo repo) {
                repo.set();
                RealChannelIO.this.onBoot(bootConfig, repo.getChannel(), repo.getPlugin(), repo.getUser(), bootCallback);
                Optional.ofNullable((Object)repo).map(PluginRepo::getUser).map(User::getPopUpChatId).ifPresent(chatId -> ChatAction.fetchPopUpChat(repo.getUser().getPopUpChatId()));
            }
        });
    }

    private void onBoot(BootConfig bootConfig, Channel channel, Plugin plugin, User user, @Nullable BootCallback bootCallback) {
        PrefSupervisor.setLatestBootData((Context)this.application, bootConfig, plugin.getId(), user.getId());
        SettingsStore.get().language.set(user.getSystemLanguage());
        SettingsStore.get().channelButtonOptionState.set(bootConfig.getChannelButtonOption());
        SettingsStore.get().hidePopup.set(bootConfig.isHidePopup());
        SettingsStore.get().trackDefaultEvent.set(bootConfig.isTrackDefaultEvent());
        SettingsStore.get().showTranslation.set(PrefSupervisor.canTranslateMessage((Context)this.application));
        SettingsStore.get().showClosedChat.set(PrefSupervisor.isShownClosedChat((Context)this.application));
        SettingsStore.get().raiseSoundVibrate.set(PrefSupervisor.isEnabledPopupAlarm((Context)this.application));
        ChatManager.initialize();
        if (GlobalStore.get().jwt.get() == null) {
            GlobalStore.get().jwt.set(PrefSupervisor.getJwt((Context)this.application));
        }
        this.registerPushToken();
        SocketManager.setChannelId(channel.getId());
        if (SettingsStore.get().showLauncher.get().booleanValue() && SettingsStore.get().trackDefaultEvent.get().booleanValue()) {
            EventAction.trackPageView();
        }
        this.handler.handle();
        if (this.lifecycleController.isForeground()) {
            this.lifecycleController.doOnActivated();
        }
        TimerStore.get().now.set(TimeUtils.getCurrentTime());
        GlobalStore.get().bootState.set(true);
        if (bootCallback != null) {
            bootCallback.onComplete(BootStatus.SUCCESS, com.zoyi.channel.plugin.android.open.model.User.newInstance(user));
        }
        PrefSupervisor.clearLatestPushData((Context)this.application);
    }

    void registerPushToken() {
        ChannelPushManager.registerPushToken((Context)this.application);
    }

    void sleep() {
        this.handler.unHandle();
        this.lifecycleController.doOnDeactivated();
        SocketManager.setChannelId(null);
        SocketManager.disconnect();
        Action.invoke(ActionType.SHUTDOWN);
        Action.release();
        ChatManager.release();
        ChatVideoManager.get().clear();
        Store.destroy();
        GlobalStore.get().bootState.set(false);
    }

    void shutdown() {
        ChannelPushManager.deregisterPushToken((Context)this.application);
        PrefSupervisor.setJwt((Context)this.application, null);
        PrefSupervisor.clearLatestBootData((Context)this.application);
        this.sleep();
    }

    public void showMessenger(Activity activity) {
        if (!GlobalStore.get().bootState.get().booleanValue()) {
            L.e("Fail to start messenger, please 'Boot' first");
            return;
        }
        IntentUtils.setNextActivity((Context)activity, LoungeActivity.class).putExtra("handleOpenChat", false).putExtra("topActivityName", GlobalSelector.getTopActivityName()).setFlag(0x24000000).setTransition(Transition.SLIDE_FROM_BOTTOM).startActivity();
    }

    public void openChat(Activity activity, @Nullable String chatId, @Nullable String message) {
        if (!GlobalStore.get().bootState.get().booleanValue()) {
            L.e("Fail to start messenger, please 'Boot' first");
            return;
        }
        IntentUtils.setNextActivity((Context)activity, LoungeActivity.class).putExtra("chatContentId", chatId).putExtra("chatPresetMessage", message).putExtra("handleOpenChat", true).putExtra("topActivityName", GlobalSelector.getTopActivityName()).setFlag(0x24000000).setTransition(Transition.SLIDE_FROM_BOTTOM).startActivity();
    }

    void setListener(@Nullable ChannelPluginListener listener) {
        this.handler.setListener(listener);
    }

    void setListener(@Nullable com.zoyi.channel.plugin.android.ChannelPluginListener listener) {
        this.handler.setLegacyListener(listener);
    }

    void clearListener() {
        this.handler.clearListener();
    }

    @Nullable
    com.zoyi.channel.plugin.android.ChannelPluginListener getLegacyListener() {
        return this.handler.getLegacyListener();
    }

    @Nullable
    ChannelPluginListener getListener() {
        return this.handler.getListener();
    }
}

