package com.zoyi.channel.plugin.android.view.popup;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.util.AttributeSet;
import android.view.View;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.entity.Previewable;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.com.annimon.stream.Optional;

import java.util.Locale;


public class BubblePopupView extends BasePopupView {

  public BubblePopupView(@NonNull Context context) {
    super(context);
  }

  public BubblePopupView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
  }

  public BubblePopupView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
  }

  @Override
  protected int getLayoutId() {
    return R.layout.ch_plugin_view_push_bubble;
  }

  @Override
  protected void setMediaSize(Previewable previewable) {
    avatarPopup.setVisibility(View.GONE);

    if (previewable.getHeight() != 0) {
      float maxRatio = 16f / 9f;
      float minRatio = 1f;
      float ratio = previewable.getWidth() / previewable.getHeight().floatValue();

      ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams) viewPopUpMedia.getLayoutParams();

      if (ratio < minRatio) {
        params.dimensionRatio = "1:1";
      } else if (ratio > maxRatio) {
        params.dimensionRatio = "16:9";
      } else {
        params.dimensionRatio = String.format(Locale.ENGLISH, "%d:%d", previewable.getWidth(), previewable.getHeight());
      }
    }
  }

  @Override
  public void show(Message message) {
    super.show(message);

    File file = message.getPrimaryFile();
    if (file != null) {
      if (!file.isPreviewable() || !message.hasBlocks()) {
        viewFileRow.setVisibility(View.VISIBLE);
        viewFileRow.setFile(file, message.getFiles().size());
      }
    }
  }

  @Override
  protected int getDefaultTextMaxLine() {
    return Optional.ofNullable(item)
        .map(Message::getPrimaryFile)
        .filter(file -> !file.isPreviewable())
        .map(file -> 1)
        .orElse(2);
  }

  @Override
  protected int getAttachmentTextMaxLine() {
    return getDefaultTextMaxLine();
  }
}
