package com.zoyi.channel.plugin.android.view.button;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.CardView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import com.zoyi.channel.plugin.android.R;

public class RefreshButton extends CardView implements View.OnClickListener {

  public RefreshButton(@NonNull Context context) {
    super(context);
    init(context);
  }

  public RefreshButton(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public RefreshButton(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  @Nullable
  private OnClickListener listener;

  private void init(Context context) {
    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_refresh_button, this, true);

    view.findViewById(R.id.ch_cardRefreshButton).setOnClickListener(this);

    if (Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP) {
      getBackground().setAlpha(0);
    } else {
      setBackgroundColor(ContextCompat.getColor(context, android.R.color.transparent));
    }
  }

  @Override
  public void setOnClickListener(@Nullable OnClickListener listener) {
    this.listener = listener;
  }

  @Override
  public void onClick(View v) {
    if (listener != null && isEnabled()) {
      listener.onClick(v);
    }
  }
}
