/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util.rxpermission;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.zoyi.channel.plugin.android.util.rxpermission.Permission;
import com.zoyi.channel.plugin.android.util.rxpermission.RxPermissionsFragment;
import com.zoyi.rx.Observable;
import com.zoyi.rx.functions.Func1;
import com.zoyi.rx.subjects.PublishSubject;
import java.util.ArrayList;
import java.util.List;

public class RxPermissions {
    static final String TAG = "RxPermissions";
    RxPermissionsFragment mRxPermissionsFragment;

    public RxPermissions(@NonNull Activity activity) {
        this.mRxPermissionsFragment = this.getRxPermissionsFragment(activity);
    }

    private RxPermissionsFragment getRxPermissionsFragment(Activity activity) {
        boolean isNewInstance;
        RxPermissionsFragment rxPermissionsFragment = this.findRxPermissionsFragment(activity);
        boolean bl = isNewInstance = rxPermissionsFragment == null;
        if (isNewInstance) {
            rxPermissionsFragment = new RxPermissionsFragment();
            FragmentManager fragmentManager = activity.getFragmentManager();
            fragmentManager.beginTransaction().add((Fragment)rxPermissionsFragment, TAG).commitAllowingStateLoss();
            fragmentManager.executePendingTransactions();
        }
        return rxPermissionsFragment;
    }

    private RxPermissionsFragment findRxPermissionsFragment(Activity activity) {
        return (RxPermissionsFragment)activity.getFragmentManager().findFragmentByTag(TAG);
    }

    public void setLogging(boolean logging) {
        this.mRxPermissionsFragment.setLogging(logging);
    }

    public Observable.Transformer<Object, Boolean> ensure(final String ... permissions) {
        return new Observable.Transformer<Object, Boolean>(){

            public Observable<Boolean> call(Observable<Object> o) {
                return RxPermissions.this.request(o, permissions).buffer(permissions.length).flatMap((Func1)new Func1<List<Permission>, Observable<Boolean>>(){

                    public Observable<Boolean> call(List<Permission> permissions) {
                        if (permissions.isEmpty()) {
                            return Observable.empty();
                        }
                        for (Permission p : permissions) {
                            if (p.granted) continue;
                            return Observable.just((Object)false);
                        }
                        return Observable.just((Object)true);
                    }
                });
            }
        };
    }

    public Observable.Transformer<Object, Permission> ensureEach(final String ... permissions) {
        return new Observable.Transformer<Object, Permission>(){

            public Observable<Permission> call(Observable<Object> o) {
                return RxPermissions.this.request(o, permissions);
            }
        };
    }

    public Observable<Boolean> request(String ... permissions) {
        return Observable.just(null).compose(this.ensure(permissions));
    }

    public Observable<Permission> requestEach(String ... permissions) {
        return Observable.just(null).compose(this.ensureEach(permissions));
    }

    private Observable<Permission> request(Observable<?> trigger, final String ... permissions) {
        if (permissions == null || permissions.length == 0) {
            throw new IllegalArgumentException("RxPermissions.request/requestEach requires at least one input permission");
        }
        return this.oneOf(trigger, this.pending(permissions)).flatMap((Func1)new Func1<Object, Observable<Permission>>(){

            public Observable<Permission> call(Object o) {
                return RxPermissions.this.requestImplementation(permissions);
            }
        });
    }

    private Observable<?> pending(String ... permissions) {
        for (String p : permissions) {
            if (this.mRxPermissionsFragment.containsByPermission(p)) continue;
            return Observable.empty();
        }
        return Observable.just(null);
    }

    private Observable<?> oneOf(Observable<?> trigger, Observable<?> pending) {
        if (trigger == null) {
            return Observable.just(null);
        }
        return Observable.merge(trigger, pending);
    }

    @TargetApi(value=23)
    private Observable<Permission> requestImplementation(String ... permissions) {
        ArrayList<Object> list = new ArrayList<Object>(permissions.length);
        ArrayList<String> unrequestedPermissions = new ArrayList<String>();
        for (String permission : permissions) {
            this.mRxPermissionsFragment.log("Requesting permission " + permission);
            if (this.isGranted(permission)) {
                list.add(Observable.just((Object)new Permission(permission, true, false)));
                continue;
            }
            if (this.isRevoked(permission)) {
                list.add(Observable.just((Object)new Permission(permission, false, false)));
                continue;
            }
            PublishSubject subject = this.mRxPermissionsFragment.getSubjectByPermission(permission);
            if (subject == null) {
                unrequestedPermissions.add(permission);
                subject = PublishSubject.create();
                this.mRxPermissionsFragment.setSubjectForPermission(permission, (PublishSubject<Permission>)subject);
            }
            list.add(subject);
        }
        if (!unrequestedPermissions.isEmpty()) {
            String[] unrequestedPermissionsArray = unrequestedPermissions.toArray(new String[unrequestedPermissions.size()]);
            this.requestPermissionsFromFragment(unrequestedPermissionsArray);
        }
        return Observable.concat((Observable)Observable.from(list));
    }

    public Observable<Boolean> shouldShowRequestPermissionRationale(Activity activity, String ... permissions) {
        if (!this.isMarshmallow()) {
            return Observable.just((Object)false);
        }
        return Observable.just((Object)this.shouldShowRequestPermissionRationaleImplementation(activity, permissions));
    }

    @TargetApi(value=23)
    private boolean shouldShowRequestPermissionRationaleImplementation(Activity activity, String ... permissions) {
        for (String p : permissions) {
            if (this.isGranted(p) || activity.shouldShowRequestPermissionRationale(p)) continue;
            return false;
        }
        return true;
    }

    @TargetApi(value=23)
    void requestPermissionsFromFragment(String[] permissions) {
        this.mRxPermissionsFragment.log("requestPermissionsFromFragment " + TextUtils.join((CharSequence)", ", (Object[])permissions));
        this.mRxPermissionsFragment.requestPermissions(permissions);
    }

    public boolean isGranted(String permission) {
        return !this.isMarshmallow() || this.mRxPermissionsFragment.isGranted(permission);
    }

    public boolean isRevoked(String permission) {
        return this.isMarshmallow() && this.mRxPermissionsFragment.isRevoked(permission);
    }

    boolean isMarshmallow() {
        return Build.VERSION.SDK_INT >= 23;
    }

    void onRequestPermissionsResult(String[] permissions, int[] grantResults) {
        this.mRxPermissionsFragment.onRequestPermissionsResult(permissions, grantResults, new boolean[permissions.length]);
    }
}

