package com.zoyi.channel.plugin.android.view.dialog;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.support.annotation.*;
import android.view.*;
import android.widget.*;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.enumerate.ButtonType;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;

import java.util.ArrayList;
import java.util.List;

public abstract class BaseDialog<E extends BaseDialog> extends Dialog {

  private TextView textTitle;
  private FrameLayout layoutContent;
  private LinearLayout layoutButtonFrame;

  private Context context;

  private String title;
  @Nullable
  private View content;
  private List<Button> buttons;

  public BaseDialog(@NonNull Context context) {
    super(context);

    this.context = context;
    this.buttons = new ArrayList<>();
  }

  @Initializer
  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);

    //다이얼로그 배경 관련 처리
    if (this.getWindow() != null) {
      this.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
    }
    requestWindowFeature(Window.FEATURE_NO_TITLE);

    setContentView(R.layout.ch_dialog_base);
    textTitle = findViewById(R.id.ch_textDialogTitle);
    layoutContent = findViewById(R.id.ch_layoutDialogContent);
    layoutButtonFrame = findViewById(R.id.ch_layoutDialogButtonFrame);

    setDialogView();
  }

  // Create dialog view

  private void setDialogView() {
    if (title != null) {
      textTitle.setVisibility(View.VISIBLE);
      textTitle.setText(title);
    }
    if (content != null) {
      layoutContent.addView(content);
    }

    int orientation = LinearLayout.HORIZONTAL;
    if (buttons.size() > 2 || (title == null && content == null)) {
      orientation = LinearLayout.VERTICAL;
    }

    layoutButtonFrame.setOrientation(orientation);

    for (Button button : buttons) {
      if (orientation == LinearLayout.VERTICAL) {
        button.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, 0, 1f));
      } else {
        button.setLayoutParams(new LinearLayout.LayoutParams(0, LinearLayout.LayoutParams.WRAP_CONTENT, 1f));
      }
      layoutButtonFrame.addView(button);
    }
  }

  // Create and set buttons

  protected Button createButton(String text, @ColorInt int color) {
    Button button = (Button) LayoutInflater.from(context).inflate(R.layout.ch_dialog_button, null);
    button.setText(text);
    button.setTextColor(color);
    return button;
  }

  protected void addButton(Button button) {
    buttons.add(button);
  }

  // Setter

  public E setTitle(String title) {
    this.title = title;
    return (E) this;
  }

  protected E setContent(View content) {
    this.content = content;
    return (E) this;
  }

  public E addButton(ButtonType type) {
    return addButton(type, null);
  }

  public E addButton(ButtonType type, @Nullable View.OnClickListener listener) {
    return addButton(type, ResUtils.getColor(R.color.ch_grey900), listener);
  }

  public E addButton(ButtonType type, @ColorInt int color, @Nullable View.OnClickListener listener) {
    switch (type) {
      case CANCEL:
        return addButton(ResUtils.getString(context, "ch.common_cancel"), color, listener);

      default:
        return addButton(ResUtils.getString(context, "ch.common_confirm"), color, listener);
    }
  }

  public E addButton(String text, @ColorInt int color, @Nullable final View.OnClickListener listener) {
    Button button = createButton(text, color);

    if (listener != null) {
      button.setOnClickListener(v -> {
        listener.onClick(v);
        dismiss();
      });
    } else {
      button.setOnClickListener(v -> dismiss());
    }
    addButton(button);

    return (E) this;
  }

  public E allowBackpress(boolean allow) {
    setCancelable(allow);
    return (E) this;
  }
}
