package com.zoyi.channel.plugin.android.activity.settings;

import android.support.annotation.Nullable;
import android.support.v7.widget.SwitchCompat;
import android.view.View;
import android.widget.*;

import com.zoyi.channel.plugin.android.BuildConfig;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.action.UserAction;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.common.error.ErrorRefreshView;
import com.zoyi.channel.plugin.android.activity.common.navigation.NavigationView;
import com.zoyi.channel.plugin.android.activity.language.LanguageSettingsActivity;
import com.zoyi.channel.plugin.android.activity.profile.EditProfileActivity;
import com.zoyi.channel.plugin.android.activity.settings.contract.SettingsContract;
import com.zoyi.channel.plugin.android.activity.settings.enumerate.OptionType;
import com.zoyi.channel.plugin.android.activity.settings.view.*;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.global.*;
import com.zoyi.channel.plugin.android.model.rest.ProfileBotSchema;
import com.zoyi.channel.plugin.android.model.rest.User;
import com.zoyi.channel.plugin.android.open.option.Language;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.channel.plugin.android.store.UserStore;
import com.zoyi.channel.plugin.android.util.*;
import com.zoyi.com.annimon.stream.Optional;

import java.util.List;

public class SettingsActivity
    extends BaseActivity2
    implements
    SettingsContract.View,
    CompoundButton.OnCheckedChangeListener,
    SettingsOptionInteractionListener {

  private SettingsContract.Presenter presenter;

  private NavigationView navigation;
  private SettingsHeaderView header;

  private SettingsOptionView optionLanguage;

  private SwitchCompat switchTranslation;
  private SwitchCompat switchShowClosedChat;
  private SwitchCompat switchSoundVibrate;
  private SwitchCompat switchMarketingUnsubscribe;

  private View profileLayout;
  private TextView textSettingsProfile;
  private LinearLayout profileContents;
  private View profileLoader;
  private ErrorRefreshView profileErrorView;

  private TextView textVersion;

  @Initializer
  @Override
  protected boolean onCreate() {
    init(R.layout.ch_plugin_activity_settings);

    navigation = findViewById(R.id.ch_navigationSettings);

    header = findViewById(R.id.ch_viewSettingsHeader);

    optionLanguage = findViewById(R.id.ch_optionSettingsLanguage);
    optionLanguage.setData(OptionType.LANGUAGE, ResUtils.getString(SettingsStore.get().language.get().toString()));
    optionLanguage.setSettingsOptionInteractionListener(this);

    switchTranslation = findViewById(R.id.ch_switchSettingsTranslation);
    switchTranslation.setChecked(SettingsStore.get().showTranslation.get());
    switchTranslation.setOnCheckedChangeListener(this);

    switchShowClosedChat = findViewById(R.id.ch_switchSettingsShowClosedChats);
    switchShowClosedChat.setChecked(SettingsStore.get().showClosedChat.get());
    switchShowClosedChat.setOnCheckedChangeListener(this);

    switchSoundVibrate = findViewById(R.id.ch_switchSettingsSoundVibrate);
    switchSoundVibrate.setChecked(SettingsStore.get().raiseSoundVibrate.get());
    switchSoundVibrate.setOnCheckedChangeListener(this);

    switchMarketingUnsubscribe = findViewById(R.id.ch_switchSettingsMarketingUnsubscribe);
    switchMarketingUnsubscribe.setChecked(Optional.ofNullable(UserStore.get().user.get()).map(User::getUnsubscribed).orElse(false));
    switchMarketingUnsubscribe.setOnCheckedChangeListener(this);

    profileLayout = findViewById(R.id.ch_layoutSettingsProfile);
    textSettingsProfile = findViewById(R.id.ch_textSettingsProfile);
    profileContents = findViewById(R.id.ch_layoutSettingsProfileContent);
    profileLoader = findViewById(R.id.ch_loaderSettingsProfile);
    profileErrorView = findViewById(R.id.ch_errorSettingsProfile);
    profileErrorView.setListener(v -> presenter.fetchProfileBotSchema());

    textVersion = findViewById(R.id.ch_textSettingsVersion);
    textVersion.setText(String.format("v%s", BuildConfig.CHANNEL_IO_VERSION));

    presenter = new SettingsPresenter(this);

    bindPresenter(presenter);

    return true;
  }

  @Override
  protected void onPause() {
    super.onPause();

    if (isFinishing()) {
      Action.invoke(ActionType.SETTINGS_CLOSED);
    }
  }

  @Override
  public void onLanguageChange(Language language) {
    optionLanguage.setData(OptionType.LANGUAGE, ResUtils.getString(language.toString()));
  }

  @Override
  public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
    if (buttonView == null) {
      return;
    }

    int id = buttonView.getId();

    if (id == R.id.ch_switchSettingsTranslation) {
      SettingsStore.get().showTranslation.set(isChecked);
      PrefSupervisor.setTranslateOption(this, isChecked);
    } else if (id == R.id.ch_switchSettingsShowClosedChats) {
      SettingsStore.get().showClosedChat.set(isChecked);
      PrefSupervisor.setShowClosedChat(this, isChecked);
    } else if (id == R.id.ch_switchSettingsSoundVibrate) {
      SettingsStore.get().raiseSoundVibrate.set(isChecked);
      PrefSupervisor.setPopupAlarm(this, isChecked);
    } else if (id == R.id.ch_switchSettingsMarketingUnsubscribe) {
      UserAction.updateSubscription(isChecked);
    }
  }

  @Override
  public void onOptionClick(OptionType optionType, @Nullable String key, @Nullable Object value) {
    switch (optionType) {
      case LANGUAGE:
        IntentUtils.setNextActivity(this, LanguageSettingsActivity.class).startActivity();
        break;

      case PROFILE:
        if (key != null) {
          IntentUtils.setNextActivity(this, EditProfileActivity.class)
              .putExtra(Const.EXTRA_PROFILE_KEY, key)
              .putExtra(Const.EXTRA_PROFILE_VALUE, Optional.ofNullable(value).map(Object::toString).orElse(null))
              .startActivity();
        }
        break;
    }
  }

  @Override
  public void onProfileBotSchemasFetchStateChange(FetchState state) {
    profileLayout.setVisibility(View.GONE);
    profileLoader.setVisibility(View.GONE);
    profileErrorView.setVisibility(View.GONE);

    switch (state) {
      case COMPLETE:
        profileLayout.setVisibility(View.VISIBLE);
        break;

      case LOADING:
        profileLoader.setVisibility(View.VISIBLE);
        break;

      case FAILED:
        profileErrorView.setVisibility(View.VISIBLE);
        break;
    }
  }

  @Override
  public void onProfileBotSchemasChange(List<ProfileBotSchema> profileBotSchemas, User user) {
    if (profileBotSchemas.size() > 0) {
      textSettingsProfile.setVisibility(View.VISIBLE);
      profileContents.setVisibility(View.VISIBLE);

      for (int i = 0; i < profileBotSchemas.size(); i++) {
        if (profileContents.getChildCount() <= i) {
          SettingsOptionView newOptionView = new SettingsOptionView(this);
          newOptionView.setSettingsOptionInteractionListener(this);

          profileContents.addView(newOptionView);
        }

        ProfileBotSchema schema = profileBotSchemas.get(i);
        SettingsOptionView optionView = (SettingsOptionView) profileContents.getChildAt(i);

        if (schema != null && schema.getNameI18n() != null && schema.getNameI18n().get() != null) {
          optionView.setData(schema, user);
          optionView.setVisibility(View.VISIBLE);
        } else {
          optionView.setVisibility(View.GONE);
        }
      }

      for (int i = profileBotSchemas.size(); i < profileContents.getChildCount(); i++) {
        profileContents.getChildAt(i).setVisibility(View.GONE);
      }
    } else {
      textSettingsProfile.setVisibility(View.GONE);
      profileContents.setVisibility(View.GONE);
    }
  }

  @Override
  public void onUnsubscribedChanged(boolean unsubscribed) {
    switchMarketingUnsubscribe.setChecked(unsubscribed);
  }
}
