/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.dialog;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.DatePicker;
import android.widget.TimePicker;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.enumerate.ButtonType;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.channel.plugin.android.view.dialog.BaseDialog;
import com.zoyi.rx.functions.Action1;
import java.util.Calendar;
import java.util.TimeZone;

public class DatetimeDialog
extends BaseDialog<DatetimeDialog> {
    private DatePicker datePicker;
    private TimePicker timePicker;
    @Nullable
    private Action1<Long> listener;

    public DatetimeDialog(@NonNull Context context) {
        super(context);
        View contentView = LayoutInflater.from((Context)context).inflate(R.layout.ch_view_datetime_dialog, null);
        this.datePicker = (DatePicker)contentView.findViewById(R.id.ch_datepickerDateTimeDialog);
        this.timePicker = (TimePicker)contentView.findViewById(R.id.ch_timepickerDateTimeDialog);
        this.addButton(ButtonType.CANCEL);
        this.addButton(ButtonType.OK, ResUtils.getColor(R.color.ch_blue400), v -> this.onClickOk());
        this.setContent(contentView);
    }

    public void show(@Nullable Long timestamp, Action1<Long> listener) {
        this.listener = listener;
        if (timestamp != null) {
            this.setTimestamp(timestamp);
        } else {
            this.setTimestamp(TimeUtils.getCurrentTime());
        }
        super.show();
    }

    private void setTimestamp(long timestamp) {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        calendar.setTimeInMillis(timestamp);
        if (this.datePicker != null && this.timePicker != null) {
            this.datePicker.updateDate(calendar.get(1), calendar.get(2), calendar.get(5));
            if (Build.VERSION.SDK_INT >= 23) {
                this.timePicker.setHour(calendar.get(11));
                this.timePicker.setMinute(calendar.get(12));
            } else {
                this.timePicker.setCurrentHour(Integer.valueOf(calendar.get(11)));
                this.timePicker.setCurrentMinute(Integer.valueOf(calendar.get(12)));
            }
        }
    }

    private void onClickOk() {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        if (this.datePicker != null && this.timePicker != null) {
            if (Build.VERSION.SDK_INT >= 23) {
                calendar.set(this.datePicker.getYear(), this.datePicker.getMonth(), this.datePicker.getDayOfMonth(), this.timePicker.getHour(), this.timePicker.getMinute(), 0);
            } else {
                calendar.set(this.datePicker.getYear(), this.datePicker.getMonth(), this.datePicker.getDayOfMonth(), this.timePicker.getCurrentHour(), this.timePicker.getCurrentMinute(), 0);
            }
            if (this.listener != null) {
                this.listener.call((Object)calendar.getTimeInMillis());
            }
        }
    }
}

