package com.zoyi.channel.plugin.android.activity.chat.dialog;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.view.reactions.ReactionsTabLayout;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.model.repo.ManagersRepo;
import com.zoyi.channel.plugin.android.model.rest.Reaction;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.dialog.bottom_sheet.BaseBottomSheetDialog;
import com.zoyi.com.annimon.stream.Collectors;
import com.zoyi.com.annimon.stream.Stream;
import com.zoyi.rx.Subscription;

import java.util.List;

public class ReactionsDialog extends BaseBottomSheetDialog {

  @NonNull
  private ReactionsTabLayout reactionsTabLayout;
  private RecyclerView recyclerViewReactions;
  private View progressReactions;

  private ReactionsAdapter adapter;

  private List<Reaction> reactions;

  @Nullable
  private Subscription subscription;

  @Initializer
  public ReactionsDialog(@NonNull Context context, List<Reaction> reactions) {
    super(context);

    this.reactions = reactions;

    View contentView = LayoutInflater.from(context).inflate(R.layout.ch_dialog_reactions, null);
    addContentView(contentView);

    setOnDismissListener(dialog -> cancelApi());

    adapter = new ReactionsAdapter();

    reactionsTabLayout = contentView.findViewById(R.id.ch_viewReactionsTab);
    reactionsTabLayout.setListener(this::setIndex);

    recyclerViewReactions = contentView.findViewById(R.id.ch_recyclerViewReactions);
    recyclerViewReactions.setAdapter(adapter);

    progressReactions = contentView.findViewById(R.id.ch_progressReactions);

    reactionsTabLayout.setTabs(
        Stream.ofNullable(reactions)
            .map(reaction -> new Pair<>(reaction.getEmojiName(), reaction.getCount()))
            .collect(Collectors.toList())
    );
    setIndex(0);
  }

  private void setIndex(int index) {
    if (index < this.reactions.size()) {
      cancelApi();

      setProgress(true);

      this.subscription = Api.getManagers(this.reactions.get(index).getManagerIds())
          .cancelBy(ActionType.SHUTDOWN)
          .run(new RestSubscriber<ManagersRepo>() {
            @Override
            public void onError(RetrofitException error) {
              setProgress(false);
            }

            @Override
            public void onSuccess(@NonNull ManagersRepo repo) {
              setProgress(false);

              adapter.setManagers(repo.getManagers());
              recyclerViewReactions.scrollToPosition(0);
            }
          });
    }
  }

  private void setProgress(boolean show) {
    Views.setVisibility(progressReactions, show);
    Views.setVisibility(recyclerViewReactions, !show, View.INVISIBLE);
  }

  private void cancelApi() {
    if (this.subscription != null && !this.subscription.isUnsubscribed()) {
      this.subscription.unsubscribe();
    }
    this.subscription = null;
  }
}
