/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.com.annimon.stream;

import com.zoyi.com.annimon.stream.IntStream;
import com.zoyi.com.annimon.stream.Objects;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.com.annimon.stream.OptionalDouble;
import com.zoyi.com.annimon.stream.OptionalLong;
import com.zoyi.com.annimon.stream.function.Function;
import com.zoyi.com.annimon.stream.function.IntConsumer;
import com.zoyi.com.annimon.stream.function.IntFunction;
import com.zoyi.com.annimon.stream.function.IntPredicate;
import com.zoyi.com.annimon.stream.function.IntSupplier;
import com.zoyi.com.annimon.stream.function.IntToDoubleFunction;
import com.zoyi.com.annimon.stream.function.IntToLongFunction;
import com.zoyi.com.annimon.stream.function.IntUnaryOperator;
import com.zoyi.com.annimon.stream.function.Supplier;
import java.util.NoSuchElementException;

public final class OptionalInt {
    private static final OptionalInt EMPTY = new OptionalInt();
    private final boolean isPresent;
    private final int value;

    private OptionalInt() {
        this.isPresent = false;
        this.value = 0;
    }

    public static OptionalInt empty() {
        return EMPTY;
    }

    private OptionalInt(int value) {
        this.isPresent = true;
        this.value = value;
    }

    public static OptionalInt of(int value) {
        return new OptionalInt(value);
    }

    public static OptionalInt ofNullable(Integer value) {
        return value == null ? EMPTY : new OptionalInt(value);
    }

    public int getAsInt() {
        return this.orElseThrow();
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public boolean isEmpty() {
        return !this.isPresent;
    }

    public void ifPresent(IntConsumer consumer) {
        if (this.isPresent) {
            consumer.accept(this.value);
        }
    }

    public void ifPresentOrElse(IntConsumer consumer, Runnable emptyAction) {
        if (this.isPresent) {
            consumer.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    public OptionalInt executeIfPresent(IntConsumer consumer) {
        this.ifPresent(consumer);
        return this;
    }

    public OptionalInt executeIfAbsent(Runnable action) {
        if (!this.isPresent()) {
            action.run();
        }
        return this;
    }

    public <R> R custom(Function<OptionalInt, R> function) {
        Objects.requireNonNull(function);
        return function.apply(this);
    }

    public OptionalInt filter(IntPredicate predicate) {
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this.value) ? this : OptionalInt.empty();
    }

    public OptionalInt filterNot(IntPredicate predicate) {
        return this.filter(IntPredicate.Util.negate(predicate));
    }

    public OptionalInt map(IntUnaryOperator mapper) {
        if (!this.isPresent()) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(mapper.applyAsInt(this.value));
    }

    public <U> Optional<U> mapToObj(IntFunction<U> mapper) {
        if (!this.isPresent()) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(this.value));
    }

    public OptionalLong mapToLong(IntToLongFunction mapper) {
        if (!this.isPresent()) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(mapper.applyAsLong(this.value));
    }

    public OptionalDouble mapToDouble(IntToDoubleFunction mapper) {
        if (!this.isPresent()) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(mapper.applyAsDouble(this.value));
    }

    public IntStream stream() {
        if (!this.isPresent()) {
            return IntStream.empty();
        }
        return IntStream.of(this.value);
    }

    public OptionalInt or(Supplier<OptionalInt> supplier) {
        if (this.isPresent()) {
            return this;
        }
        Objects.requireNonNull(supplier);
        return Objects.requireNonNull(supplier.get());
    }

    public int orElse(int other) {
        return this.isPresent ? this.value : other;
    }

    public int orElseGet(IntSupplier other) {
        return this.isPresent ? this.value : other.getAsInt();
    }

    public int orElseThrow() {
        if (!this.isPresent) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public <X extends Throwable> int orElseThrow(Supplier<X> exceptionSupplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptionalInt)) {
            return false;
        }
        OptionalInt other = (OptionalInt)obj;
        return this.isPresent && other.isPresent ? this.value == other.value : this.isPresent == other.isPresent;
    }

    public int hashCode() {
        return this.isPresent ? this.value : 0;
    }

    public String toString() {
        return this.isPresent ? String.format("OptionalInt[%s]", this.value) : "OptionalInt.empty";
    }
}

