package com.zoyi.channel.plugin.android.selector;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.UserChatItem;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.open.option.Language;
import com.zoyi.channel.plugin.android.store.*;
import com.zoyi.channel.plugin.android.store.binder.*;
import com.zoyi.channel.plugin.android.store.state.*;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Action2;

import java.util.ArrayList;
import java.util.List;

public class ChatsSelector {

  public static Binder bindUserChatsMore(Action2<Boolean, Integer> action2) {
    State<String> nextChatState = UserChatStore.get().next;
    EntityMapState<UserChat> userChatsState = UserChatStore.get().userChats;
    EnumState<Language> languageState = SettingsStore.get().language;

    return new Binder3<>(nextChatState, userChatsState, languageState)
        .bind((next, userChats, language) -> {
          int visibleChatsCount = 0;
          int invisibleChatsCount = 0;

          if (userChats != null) {
            for (UserChat userChat : userChats.values()) {
              if (!userChat.isStateClosed() && !userChat.isStateRemoved()) {

                if (visibleChatsCount < Const.LOUNGE_PREVIEW_MAX_CHATS) {
                  visibleChatsCount++;
                } else {
                  invisibleChatsCount++;
                }
              } else if (userChat.isStateClosed()) {
                invisibleChatsCount++;
              }
            }
          }

          action2.call(
              (next != null && !next.isEmpty()) || invisibleChatsCount > Const.COUNT_LIMIT,
              Math.min(invisibleChatsCount, Const.COUNT_LIMIT)
          );
        });
  }

  public static Binder bindChats(Action2<List<ChatItem>, List<ChatItem>> action2) {
    EntityMapState<UserChat> userChatsState = UserChatStore.get().userChats;
    EntityMapState<Session> sessionsState = UserChatStore.get().sessions;
    EntityMapState<Message> messagesState = UserChatStore.get().messages;
    EntityMapState<Manager> managersState = ManagerStore.get().managers;
    EntityMapState<Bot> botsState = BotStore.get().bots;
    State<String> defaultBotIdState = BotStore.get().defaultBotId;
    BooleanState showClosedChatsState = SettingsStore.get().showClosedChat;

    return new Binder7<>(
        userChatsState,
        sessionsState,
        messagesState,
        managersState,
        botsState,
        defaultBotIdState,
        showClosedChatsState
    ).bind((userChats, sessions, messages, managers, bots, defaultBotId, showClosedChat) -> {
      List<ChatItem> activeChatItems = new ArrayList<>();
      List<ChatItem> closedChatItems = new ArrayList<>();

      for (UserChat userChat : userChats.values()) {
        if (userChat.isStateRemoved()) {
          continue;
        }

        Message message = messages.get(userChat.getId());
        Session session = sessions.get(userChat.getId());
        ProfileEntity profileEntity = null;
        if (userChat.getAssigneeId() != null) {
          profileEntity = managers.get(userChat.getAssigneeId());
        }
        if (profileEntity == null && message != null && Const.BOT.equals(message.getPersonType()) && message.getPersonId() != null) {
          profileEntity = bots.get(message.getPersonId());
        }
        if (profileEntity == null && defaultBotId != null) {
          profileEntity = bots.get(defaultBotId);
        }

        ChatItem newChatItem = new UserChatItem(userChat, message, session, profileEntity);

        if (showClosedChat && userChat.isStateClosed()) {
          closedChatItems.add(newChatItem);
        } else if (!userChat.isStateClosed()) {
          activeChatItems.add(newChatItem);
        }
      }

      action2.call(activeChatItems, closedChatItems);
    });
  }

  public static Binder bindUserChatsFetchState(Action1<FetchState> action1) {
    return new Binder1<>(UserChatStore.get().userChatsFetchState).bind(action1);
  }

  public static Binder binderHost(@Nullable String chatId, Action1<ProfileEntity> action1) {
    EntityMapState<UserChat> userChatsState = UserChatStore.get().userChats;
    EntityMapState<Manager> managersState = ManagerStore.get().managers;
    State<Channel> channelState = ChannelStore.get().channelState;

    return new Binder3<>(userChatsState, managersState, channelState).bind(
        (userChats, managers, channel) -> {
          UserChat userChat = chatId != null ? userChats.get(chatId) : null;

          if (userChat == null) {
            action1.call(channel);
            return;
          }

          Manager manager = userChat.getAssigneeId() != null
              ? managers.get(userChat.getAssigneeId())
              : null;

          if (manager != null) {
            action1.call(manager);
          } else {
            action1.call(channel);
          }
        });
  }
}
