/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.youtube.player.option;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

public class IFramePlayerOptions {
    private JSONObject playerOptions;
    public static IFramePlayerOptions DEFAULT = new Builder().build();

    public IFramePlayerOptions(JSONObject playerOptions) {
        this.playerOptions = playerOptions;
    }

    @NonNull
    public String toString() {
        return this.playerOptions.toString();
    }

    @Nullable
    public String getOrigin() {
        try {
            return this.playerOptions.getString("origin");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class Builder {
        private static final String AUTO_PLAY = "autoplay";
        private static final String CONTROLS = "controls";
        private static final String ENABLE_JS_API = "enablejsapi";
        private static final String FS = "fs";
        private static final String REL = "rel";
        private static final String SHOW_INFO = "showinfo";
        private static final String IV_LOAD_POLICY = "iv_load_policy";
        private static final String MODEST_BRANDING = "modestbranding";
        private static final String CC_LOAD_POLICY = "cc_load_policy";
        private static final String CC_LANG_PREF = "cc_lang_pref";
        public static final String ORIGIN = "origin";
        private JSONObject builderOptions = new JSONObject();

        public Builder() {
            this.addInt(AUTO_PLAY, 0);
            this.addInt(CONTROLS, 0);
            this.addInt(ENABLE_JS_API, 1);
            this.addInt(FS, 0);
            this.addString(ORIGIN, "https://www.youtube.com");
            this.addInt(REL, 0);
            this.addInt(SHOW_INFO, 0);
            this.addInt(IV_LOAD_POLICY, 3);
            this.addInt(MODEST_BRANDING, 1);
            this.addInt(CC_LOAD_POLICY, 0);
        }

        public IFramePlayerOptions build() {
            return new IFramePlayerOptions(this.builderOptions);
        }

        public Builder controls(Integer controls) {
            this.addInt(CONTROLS, controls);
            return this;
        }

        public Builder rel(Integer rel) {
            this.addInt(REL, rel);
            return this;
        }

        public Builder ivLoadPolicy(Integer ivLoadPolicy) {
            this.addInt(IV_LOAD_POLICY, ivLoadPolicy);
            return this;
        }

        public Builder langPref(String languageCode) {
            this.addString(CC_LANG_PREF, languageCode);
            return this;
        }

        public Builder ccLoadPolicy(Integer ccLoadPolicy) {
            this.addInt(CC_LOAD_POLICY, ccLoadPolicy);
            return this;
        }

        public Builder origin(String origin) {
            this.addString(ORIGIN, origin);
            return this;
        }

        private void addString(String key, String value) {
            try {
                this.builderOptions.put(key, (Object)value);
            }
            catch (JSONException e) {
                throw new RuntimeException(String.format("Illegal JSON value %s: %s", key, value));
            }
        }

        private void addInt(String key, Integer value) {
            try {
                this.builderOptions.put(key, (Object)value);
            }
            catch (JSONException e) {
                throw new RuntimeException(String.format("Illegal JSON value %s: %s", key, value));
            }
        }
    }
}

