/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.model.rest;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.PersonEntity;
import com.zoyi.channel.plugin.android.model.rest.Block;
import com.zoyi.channel.plugin.android.model.rest.Button;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.model.rest.Log;
import com.zoyi.channel.plugin.android.model.rest.Marketing;
import com.zoyi.channel.plugin.android.model.rest.MessageAction;
import com.zoyi.channel.plugin.android.model.rest.ProfileBot;
import com.zoyi.channel.plugin.android.model.rest.WebPage;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.com.annimon.stream.Stream;
import java.util.List;

public class Message
implements Entity,
PersonEntity {
    private String id;
    @Nullable
    private String channelId;
    @Nullable
    private String chatType;
    @Nullable
    private String chatId;
    @Nullable
    private String personType;
    @Nullable
    private String personId;
    @Nullable
    private List<Block> blocks;
    @Nullable
    private String plainText;
    @Nullable
    private Long createdAt;
    @Nullable
    private String requestId;
    @Nullable
    private List<File> files;
    @Nullable
    private WebPage webPage;
    @Nullable
    private Log log;
    @Nullable
    private List<ProfileBot> profileBot;
    @Nullable
    private MessageAction action;
    @Nullable
    private String language;
    @Nullable
    private String state;
    @Nullable
    private Marketing marketing;
    @Nullable
    private List<Button> buttons;
    public static final String CLASSNAME = "message";

    @Override
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getChatId() {
        return this.chatId;
    }

    @Override
    @Nullable
    public String getPersonType() {
        return this.personType;
    }

    @Override
    @Nullable
    public String getPersonId() {
        return this.personId;
    }

    @Nullable
    public List<Block> getBlocks() {
        if (!this.isDeleted()) {
            return this.blocks;
        }
        return null;
    }

    public boolean hasBlocks() {
        return this.blocks != null && !this.blocks.isEmpty();
    }

    @NonNull
    public String getPlainText() {
        if (this.plainText != null) {
            return this.plainText;
        }
        return "";
    }

    public void setPlainText(@Nullable String plainText) {
        this.plainText = plainText;
    }

    @NonNull
    public Long getCreatedAt() {
        if (this.createdAt == null) {
            return TimeUtils.getCurrentTime();
        }
        return this.createdAt;
    }

    @Nullable
    public String getRequestId() {
        return this.requestId;
    }

    @Nullable
    public List<File> getFiles() {
        if (!this.isDeleted()) {
            return this.files;
        }
        return null;
    }

    public boolean containsPreviewableFile() {
        return !Stream.ofNullable(this.files).filter(File::isPreviewable).toList().isEmpty();
    }

    @Nullable
    public WebPage getWebPage() {
        if (!this.isDeleted()) {
            return this.webPage;
        }
        return null;
    }

    @Nullable
    public Log getLog() {
        return this.log;
    }

    @Nullable
    public List<ProfileBot> getProfileBot() {
        return this.profileBot;
    }

    @Nullable
    public MessageAction getAction() {
        return this.action;
    }

    @Nullable
    public String getState() {
        return this.state;
    }

    @Nullable
    public String getLanguage() {
        return this.language;
    }

    public void clearAction() {
        this.action = null;
    }

    public boolean isDeleted() {
        return "removed".equals(this.state);
    }

    @Nullable
    public Marketing getMarketing() {
        return this.marketing;
    }

    @Nullable
    public List<Button> getButtons() {
        return this.buttons;
    }

    @Nullable
    public File getPrimaryFile() {
        if (this.files == null || this.files.isEmpty()) {
            return null;
        }
        for (File file : this.files) {
            if (!file.isVideo()) continue;
            return file;
        }
        for (File file : this.files) {
            if (!file.isImage()) continue;
            return file;
        }
        return this.files.get(0);
    }

    public boolean hasContents() {
        return this.blocks != null || this.buttons != null || this.webPage != null || this.files != null;
    }
}

