package com.zoyi.channel.plugin.android.action;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.model.rest.SupportBotEntry;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.repo.MessageRepo;
import com.zoyi.channel.plugin.android.model.repo.UserChatRepo;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.store.SupportBotStore;
import com.zoyi.channel.plugin.android.store.UserChatStore;

public class SupportBotAction {

  public static void createSupportBotUserChat(
      @Nullable String supportBotId,
      @Nullable String url,
      RestSubscriber<UserChatRepo> subscriber
  ) {
    if (supportBotId != null && url != null) {
      Api.createSupportBotUserChat(supportBotId, url)
          .runBy(ActionType.CREATE_USER_CHAT)
          .cancelBy(ActionType.SHUTDOWN)
          .run(subscriber);
    }
  }

  public static void createMarketingSupportBotUserChat(@Nullable String userChatId) {
    SupportBotEntry supportBotEntry = SupportBotStore.get().supportBotState.get();
    UserChat userChat = UserChatStore.get().userChats.get(userChatId);

    String sourceType = userChat != null ? userChat.getSourceType() : null;
    String sourceId = userChat != null ? userChat.getSourceId() : null;

    if (userChatId != null && supportBotEntry != null) {
      Api.createMarketingSupportBotUserChat(userChatId, supportBotEntry.getId(), sourceType, sourceId)
          .runBy(ActionType.CREATE_SUPPORT_BOT)
          .cancelBy(ActionType.SHUTDOWN)
          .run(new RestSubscriber<MessageRepo>() {
            @Override
            public void onSuccess(@NonNull MessageRepo repo) {
              UserChatStore.get().messages.upsert(repo.getMessage());
            }
          });
    }
  }
}
