package com.zoyi.channel.plugin.android.model.etc;

import com.zoyi.channel.plugin.android.enumerate.TranslationState;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.rest.Block;

import java.util.List;

/**
 * Created by jerry on 2018. 7. 9..
 */

public class TranslationInfo implements Entity {

  private String key;
  private List<Block> blocks;
  private TranslationState state;

  public TranslationInfo(String key, List<Block> blocks, TranslationState state) {
    this.key = key;
    this.blocks = blocks;
    this.state = state;
  }

  public List<Block> getBlocks() {
    return blocks;
  }

  public TranslationState getState() {
    return state;
  }

  public TranslationInfo setState(TranslationState state) {
    this.state = state;

    return this;
  }

  @Override
  public String getId() {
    return key;
  }

  public static String createKey(String chatId, String messageId, String language) {
    return String.format("%s:%s:%s", chatId, messageId, language);
  }

  public static TranslationInfo createProgressStateInfo(String id) {
    return new TranslationInfo(id, null, TranslationState.PROGRESS);
  }
}
