/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view.viewholder;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.support.constraint.ConstraintSet;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnWebPageActionListener;
import com.zoyi.channel.plugin.android.activity.chat.view.viewholder.MessageContentView;
import com.zoyi.channel.plugin.android.model.rest.WebPage;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.media_thumbnail.WebPageMediaThumbnailView;
import java.util.Locale;

public class WebPageContentView
extends ConstraintLayout
implements MessageContentView {
    private ConstraintLayout rootMessageWebPage;
    private WebPageMediaThumbnailView thumbnailMessageWebPage;
    private View layoutMessageWebPageMeta;
    private TextView textMessageWebPageTitle;
    private TextView textMessageWebPageDescription;
    private View layoutMessageWebPagePublisher;
    private ImageView iconMessageWebPagePublisher;
    private TextView textMessageWebPagePublisher;
    private View viewMessageWebPagePublisherDivider;
    private TextView textMessageWebPageAuthor;
    @Nullable
    private OnWebPageActionListener listener;
    @Nullable
    private WebPage webPage;

    public WebPageContentView(Context context) {
        super(context);
        this.init(context);
    }

    public WebPageContentView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public WebPageContentView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.ch_holder_message_content_web_page, (ViewGroup)this);
        this.rootMessageWebPage = (ConstraintLayout)this.findViewById(R.id.ch_rootMessageWebPage);
        this.layoutMessageWebPageMeta = this.findViewById(R.id.ch_layoutMessageWebPageMeta);
        this.textMessageWebPageTitle = (TextView)this.findViewById(R.id.ch_textMessageWebPageTitle);
        this.textMessageWebPageDescription = (TextView)this.findViewById(R.id.ch_textMessageWebPageDescription);
        this.layoutMessageWebPagePublisher = this.findViewById(R.id.ch_layoutMessageWebPagePublisher);
        this.iconMessageWebPagePublisher = (ImageView)this.findViewById(R.id.ch_iconMessageWebPagePublisher);
        this.textMessageWebPagePublisher = (TextView)this.findViewById(R.id.ch_textMessageWebPagePublisher);
        this.viewMessageWebPagePublisherDivider = this.findViewById(R.id.ch_viewMessageWebPagePublisherDivider);
        this.textMessageWebPageAuthor = (TextView)this.findViewById(R.id.ch_textMessageWebPageAuthor);
        this.thumbnailMessageWebPage = (WebPageMediaThumbnailView)this.findViewById(R.id.ch_thumbnailMessageWebPage);
        this.thumbnailMessageWebPage.setOnClickListener(view -> {
            if (this.webPage != null && this.listener != null) {
                this.listener.onUrlClick(this.webPage.getUrl());
            }
        });
    }

    public void setOnWebPageActionListener(@Nullable OnWebPageActionListener listener) {
        this.listener = listener;
    }

    public void setGravity(int gravity) {
        if (this.rootMessageWebPage != null && this.thumbnailMessageWebPage != null) {
            ConstraintSet set = new ConstraintSet();
            set.clone(this.rootMessageWebPage);
            if (gravity == 0x800003) {
                set.setHorizontalBias(R.id.ch_thumbnailMessageWebPage, 0.0f);
            } else if (gravity == 0x800005) {
                set.setHorizontalBias(R.id.ch_thumbnailMessageWebPage, 1.0f);
            }
            set.applyTo(this.rootMessageWebPage);
        }
    }

    public void setWebPage(@Nullable String messageId, WebPage webPage) {
        this.webPage = webPage;
        if (webPage.getPreviewUrl() != null && this.thumbnailMessageWebPage != null) {
            this.thumbnailMessageWebPage.setVisibility(0);
            ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)this.thumbnailMessageWebPage.getLayoutParams();
            params.dimensionRatio = webPage.getWidth() > 0 && webPage.getHeight() > 0 ? String.format(Locale.ENGLISH, "H,%d:%d", webPage.getWidth(), webPage.getHeight()) : "H,1000:524";
            this.thumbnailMessageWebPage.setWebPage(messageId, webPage);
        }
        if (webPage.getTitle() != null || webPage.getDescription() != null) {
            if (this.layoutMessageWebPageMeta != null) {
                this.layoutMessageWebPageMeta.setVisibility(0);
            }
            if (webPage.getTitle() != null && this.textMessageWebPageTitle != null) {
                this.textMessageWebPageTitle.setVisibility(0);
                this.textMessageWebPageTitle.setText((CharSequence)webPage.getTitle());
            }
            if (webPage.getDescription() != null && this.textMessageWebPageDescription != null) {
                this.textMessageWebPageDescription.setVisibility(0);
                this.textMessageWebPageDescription.setText((CharSequence)webPage.getDescription());
            }
            if (webPage.getPublisher() != null || webPage.getAuthor() != null) {
                if (this.layoutMessageWebPagePublisher != null) {
                    this.layoutMessageWebPagePublisher.setVisibility(0);
                }
                if (this.iconMessageWebPagePublisher != null && "YouTube".equals(webPage.getPublisher())) {
                    this.iconMessageWebPagePublisher.setVisibility(0);
                    this.iconMessageWebPagePublisher.setImageResource(R.drawable.ch_logo_youtube);
                }
                if (webPage.getPublisher() != null && this.textMessageWebPagePublisher != null) {
                    this.textMessageWebPagePublisher.setVisibility(0);
                    this.textMessageWebPagePublisher.setText((CharSequence)webPage.getPublisher());
                }
                if (this.viewMessageWebPagePublisherDivider != null && webPage.getPublisher() != null && webPage.getAuthor() != null) {
                    this.viewMessageWebPagePublisherDivider.setVisibility(0);
                }
                if (webPage.getAuthor() != null && this.textMessageWebPageAuthor != null) {
                    this.textMessageWebPageAuthor.setVisibility(0);
                    this.textMessageWebPageAuthor.setText((CharSequence)webPage.getAuthor());
                }
            }
        }
    }

    @Override
    public void clear() {
        if (this.thumbnailMessageWebPage != null) {
            this.thumbnailMessageWebPage.clear();
        }
    }

    @Override
    public void resetView() {
        if (this.webPage != null) {
            this.webPage = null;
            if (this.thumbnailMessageWebPage != null) {
                this.thumbnailMessageWebPage.setVisibility(8);
            }
            if (this.layoutMessageWebPageMeta != null) {
                this.layoutMessageWebPageMeta.setVisibility(8);
            }
            if (this.textMessageWebPageTitle != null) {
                this.textMessageWebPageTitle.setVisibility(8);
            }
            if (this.textMessageWebPageDescription != null) {
                this.textMessageWebPageDescription.setVisibility(8);
            }
            if (this.layoutMessageWebPagePublisher != null) {
                this.layoutMessageWebPagePublisher.setVisibility(8);
            }
            if (this.iconMessageWebPagePublisher != null) {
                this.iconMessageWebPagePublisher.setVisibility(8);
            }
            if (this.textMessageWebPagePublisher != null) {
                this.textMessageWebPagePublisher.setVisibility(8);
            }
            if (this.viewMessageWebPagePublisherDivider != null) {
                this.viewMessageWebPagePublisherDivider.setVisibility(8);
            }
            if (this.textMessageWebPageAuthor != null) {
                this.textMessageWebPageAuthor.setVisibility(8);
            }
        }
    }
}

