package com.zoyi.channel.plugin.android.activity.chat.view.viewholder;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.*;
import android.widget.FrameLayout;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnActionButtonClickListener;
import com.zoyi.channel.plugin.android.model.rest.ActionButton;
import com.zoyi.channel.plugin.android.selector.StyleSelector;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.message.MessageParserUtils;
import com.zoyi.channel.plugin.android.view.layout.ChBorderLayout;

public class ActionButtonView extends FrameLayout implements View.OnTouchListener {

  private ChBorderLayout borderActionButton;
  private TextView textActionButton;

  private String actionType;
  private ActionButton actionButton;

  @Nullable
  private OnActionButtonClickListener listener;

  private int defaultBackColor = Color.WHITE;
  private int defaultTextColor;
  private int defaultBorderColor;

  public ActionButtonView(
      Context context,
      @NonNull String actionType,
      @NonNull ActionButton actionButton,
      @Nullable OnActionButtonClickListener listener
  ) {
    super(context);

    this.actionType = actionType;
    this.actionButton = actionButton;
    this.listener = listener;

    LayoutInflater.from(context).inflate(R.layout.ch_holder_item_action_button, this);

    borderActionButton = findViewById(R.id.ch_borderActionButton);
    textActionButton = findViewById(R.id.ch_textActionButton);

    defaultTextColor = ResUtils.getColor(context, R.color.ch_black_70);
    defaultBorderColor = ResUtils.getColor(context, R.color.ch_grey900);

    setOnTouchListener(this);

    textActionButton.setText(MessageParserUtils.parseText(actionButton.getText()).toString());
  }

  @Override
  public boolean onTouch(View v, MotionEvent event) {
    switch (event.getAction()) {

      case MotionEvent.ACTION_DOWN:
        changeColor(true);
        break;

      case MotionEvent.ACTION_CANCEL:
        changeColor(false);
        break;

      case MotionEvent.ACTION_UP:
        changeColor(false);

        if (listener != null) {
          listener.onActionClick(actionType, actionButton);
        }
        break;
    }
    return true;
  }

  private void changeColor(boolean isClicked) {
    borderActionButton.setBorderColor(isClicked ? StyleSelector.getBackColor() : defaultBorderColor);
    borderActionButton.setBackColor(isClicked ? StyleSelector.getBackColor() : defaultBackColor);
    textActionButton.setTextColor(isClicked ? StyleSelector.getTextColor() : defaultTextColor);
  }
}
