/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.profile;

import android.content.Context;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.action.UserAction;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.common.navigation.NavigationView;
import com.zoyi.channel.plugin.android.activity.profile.view.BaseEditProfileView;
import com.zoyi.channel.plugin.android.enumerate.ButtonType;
import com.zoyi.channel.plugin.android.model.rest.I18n;
import com.zoyi.channel.plugin.android.model.rest.ProfileBotSchema;
import com.zoyi.channel.plugin.android.selector.ProfileBotSelector;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.view.dialog.ChannelDialog;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.rx.functions.Action1;

public class EditProfileActivity
extends BaseActivity2 {
    private NavigationView navigation;
    @Nullable
    private BaseEditProfileView editProfileView;
    @Nullable
    private String key;

    @Override
    @Initializer
    protected boolean onCreate() {
        this.init(R.layout.ch_plugin_activity_edit_profile);
        this.navigation = (NavigationView)this.findViewById(R.id.ch_navigationEditProfile);
        this.key = this.getString("EXTRA_PROFILE_KEY");
        ProfileBotSchema schema = ProfileBotSelector.getProfileBotSchemaByKey(this.key);
        if (this.key == null || schema == null) {
            return false;
        }
        this.navigation.setTitle((String)Optional.ofNullable((Object)schema).map(ProfileBotSchema::getNameI18n).map(I18n::get).orElse((Object)ResUtils.getString("ch.settings.my_profile")));
        this.navigation.addAction(ResUtils.getString("ch.settings.save"), v -> this.save());
        this.editProfileView = "mobileNumber".equals(this.key) ? (BaseEditProfileView)this.findViewById(R.id.ch_viewEditProfileMobileNumber) : ("boolean".equals(schema.getType()) ? (BaseEditProfileView)this.findViewById(R.id.ch_viewEditProfileBoolean) : ("number".equals(schema.getType()) ? (BaseEditProfileView)this.findViewById(R.id.ch_viewEditProfileNumber) : ("date".equals(schema.getType()) ? (BaseEditProfileView)this.findViewById(R.id.ch_viewEditProfileDate) : (BaseEditProfileView)this.findViewById(R.id.ch_viewEditProfileString))));
        if (this.editProfileView != null) {
            this.editProfileView.setVisibility(0);
            this.editProfileView.setValue(this.getString("EXTRA_PROFILE_VALUE"));
        }
        return true;
    }

    protected void onStart() {
        super.onStart();
        if (this.editProfileView != null) {
            this.editProfileView.focus();
        }
    }

    private void save() {
        if (this.editProfileView != null) {
            if (this.editProfileView.isValidValue()) {
                this.updateProfile(this.editProfileView.getValue());
            } else {
                ((ChannelDialog)((Object)new ChannelDialog((Context)this).setDescription(ResUtils.getString("ch.profile_form.error")).addButton(ButtonType.OK))).show();
            }
        }
    }

    private void updateProfile(@Nullable Object value) {
        this.showProgress();
        UserAction.updateUserProfile(this.key, value, () -> {
            this.hideProgress();
            this.finish();
        }, (Action1<String>)((Action1)message -> {
            this.hideProgress();
            if (message != null) {
                ((ChannelDialog)((Object)((Object)new ChannelDialog((Context)this).setDescription((String)message).addButton(ButtonType.OK)))).show();
            }
        }));
    }
}

