package com.zoyi.channel.plugin.android.selector;

import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.store.InAppPushStore;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.channel.plugin.android.store.binder.Binder;
import com.zoyi.channel.plugin.android.store.binder.Binder2;
import com.zoyi.channel.plugin.android.store.state.BooleanState;
import com.zoyi.channel.plugin.android.store.state.State;
import com.zoyi.rx.functions.Action1;

public class InAppPushSelector {

  public static Binder bindInAppPush(Action1<Message> action1) {
    State<Message> inAppPushMessageState = InAppPushStore.get().inAppPushMessage;
    BooleanState hidePopupState = SettingsStore.get().hidePopup;

    return new Binder2<>(inAppPushMessageState, hidePopupState)
        .bind((message, hidePopup) -> {
          if (message != null && !hidePopup) {
            action1.call(message);
          } else {
            action1.call(null);
          }
        });
  }
}
