package com.zoyi.channel.plugin.android.store;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.open.option.ChannelButtonOption;
import com.zoyi.channel.plugin.android.open.option.Language;
import com.zoyi.channel.plugin.android.store.base.Store;
import com.zoyi.channel.plugin.android.store.state.BooleanState;
import com.zoyi.channel.plugin.android.store.state.EnumState;
import com.zoyi.channel.plugin.android.store.state.State;

public class SettingsStore extends Store {

  public BooleanState showLauncher = new BooleanState(false);

  public EnumState<Language> language = new EnumState<>(Language.ENGLISH);

  public BooleanState showTranslation = new BooleanState(true);

  public BooleanState showClosedChat = new BooleanState(false);

  public BooleanState raiseSoundVibrate = new BooleanState(true);

  public BooleanState trackDefaultEvent = new BooleanState(Const.DEFAULT_SETTINGS_ENABLED_TRACK_DEFAULT_EVENT);

  public BooleanState hidePopup = new BooleanState(Const.DEFAULT_SETTINGS_HIDE_DEFAULT_IN_APP_PUSH);

  public State<ChannelButtonOption> channelButtonOptionState = new State<>();

  @Override
  protected void reset() {
    language.reset();
    showTranslation.reset();
    showClosedChat.reset();
    raiseSoundVibrate.reset();
    trackDefaultEvent.reset();
    hidePopup.reset();
    channelButtonOptionState.reset();
  }

  public static SettingsStore get() {
    return Store.getInstance(SettingsStore.class);
  }
}
