package com.zoyi.channel.plugin.android.view.youtube.player.util;

import android.view.View;
import android.view.ViewGroup;

import com.zoyi.channel.plugin.android.view.youtube.player.listener.YouTubePlayerFullScreenListener;

import java.util.HashSet;
import java.util.Set;

public class FullScreenHelper {

  private View targetView;

  private boolean isFullScreen;

  private Set<YouTubePlayerFullScreenListener> fullScreenListeners;

  public FullScreenHelper(View targetView) {
    this.targetView = targetView;
    this.isFullScreen = false;
    this.fullScreenListeners = new HashSet<>();
  }

  public boolean isFullScreen() {
    return isFullScreen;
  }

  public void enterFullScreen() {
    if (isFullScreen) {
      return;
    }

    isFullScreen = true;

    ViewGroup.LayoutParams viewParams = targetView.getLayoutParams();
    viewParams.height = ViewGroup.LayoutParams.MATCH_PARENT;
    viewParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
    targetView.setLayoutParams(viewParams);

    for (YouTubePlayerFullScreenListener fullScreenListener : fullScreenListeners) {
      fullScreenListener.onYouTubePlayerEnterFullScreen();
    }
  }

  public void exitFullScreen() {
    if (!isFullScreen) {
      return;
    }

    isFullScreen = false;

    ViewGroup.LayoutParams viewParams = targetView.getLayoutParams();
    viewParams.height = ViewGroup.LayoutParams.WRAP_CONTENT;
    viewParams.width = ViewGroup.LayoutParams.MATCH_PARENT;
    targetView.setLayoutParams(viewParams);

    for (YouTubePlayerFullScreenListener fullScreenListener : fullScreenListeners) {
      fullScreenListener.onYouTubePlayerExitFullScreen();
    }
  }

  public void toggleFullScreen() {
    if (isFullScreen) {
      exitFullScreen();
    } else {
      enterFullScreen();
    }
  }

  public boolean addFullScreenListener(YouTubePlayerFullScreenListener fullScreenListener) {
    return fullScreenListeners.add(fullScreenListener);
  }

  public boolean removeFullScreenListener(YouTubePlayerFullScreenListener fullScreenListener) {
    return fullScreenListeners.remove(fullScreenListener);
  }
}
