package com.zoyi.channel.plugin.android.open.model;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.open.option.Language;

import java.util.List;
import java.util.Map;

public class User {

  private String id;
  @Nullable
  private String memberId;
  @Nullable
  private String name;
  @Nullable
  private String avatarUrl;
  private int alert;
  @Nullable
  private Map<String, Object> profile;
  private boolean unsubscribed;
  @Nullable
  private List<String> tags;
  private Language language;

  @Nullable
  public static User newInstance(@Nullable com.zoyi.channel.plugin.android.model.rest.User userEntity) {
    return userEntity != null ? new User(userEntity) : null;
  }

  private User(com.zoyi.channel.plugin.android.model.rest.User user) {
    this.id = user.getId();
    this.memberId = user.getMemberId();
    this.name = user.getName();
    this.avatarUrl = user.getAvatarUrl();
    this.alert = user.getAlert();
    this.profile = user.getProfile();
    this.unsubscribed = user.getUnsubscribed();
    this.tags = user.getTags();
    this.language = user.getLanguage();
  }

  public String getId() {
    return id;
  }

  @Nullable
  public String getMemberId() {
    return memberId;
  }

  @Nullable
  public String getName() {
    return name;
  }

  @Nullable
  public String getAvatarUrl() {
    return avatarUrl;
  }

  public int getAlert() {
    return alert;
  }

  @Nullable
  public Map<String, Object> getProfile() {
    return profile;
  }

  public boolean isUnsubscribed() {
    return unsubscribed;
  }

  @Nullable
  public List<String> getTags() {
    return tags;
  }

  public Language getLanguage() {
    return language;
  }

  // Legacy converter

  public com.zoyi.channel.plugin.android.User toLegacy() {
    return new com.zoyi.channel.plugin.android.User(id, memberId, name, avatarUrl, alert, profile, unsubscribed, tags);
  }
}
