package com.zoyi.channel.plugin.android.open.model;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Message;

public class PopupData {

  @Nullable
  private String chatId;
  @Nullable
  private String avatarUrl;
  @Nullable
  private String name;
  @Nullable
  private String message;

  public PopupData(Message message, ProfileEntity profile) {
    this.name = profile.getName();
    this.avatarUrl = profile.getAvatarUrl();
    this.chatId = message.getChatId();
    this.message = message.getPlainText();
  }

  @Nullable
  public String getChatId() {
    return chatId;
  }

  @Nullable
  public String getAvatarUrl() {
    return avatarUrl;
  }

  @Nullable
  public String getMessage() {
    return message;
  }

  @Nullable
  public String getName() {
    return name;
  }
}
