package com.zoyi.channel.plugin.android.open.option;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.global.Const;

import java.util.Locale;

public enum Language {
  KOREAN(Const.KOREAN),
  JAPANESE(Const.JAPANESE),
  ENGLISH(Const.ENGLISH);

  final String string;

  Language(String string) {
    this.string = string;
  }

  public static Language fromString(String languageCode) {
    if (languageCode != null) {
      switch (languageCode) {
        case Const.KOREAN:
          return KOREAN;
        case Const.JAPANESE:
          return JAPANESE;
      }
    }
    return ENGLISH;
  }

  public static Language getDeviceLanguage() {
    String languageCode = Locale.getDefault().getLanguage();

    if (languageCode != null) {
      switch (languageCode) {
        case Const.KOREAN:
          return KOREAN;
        case Const.JAPANESE:
          return JAPANESE;
      }
    }
    return ENGLISH;
  }

  @Override
  public String toString() {
    return string;
  }

  @Nullable
  public static Language fromLegacy(@Nullable CHLocale locale) {
    if (locale != null) {
      switch (locale) {
        case KOREAN: return KOREAN;
        case JAPANESE: return JAPANESE;
        default: return ENGLISH;
      }
    }
    return null;
  }
}
