package com.zoyi.channel.plugin.android.open.option;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.ChannelLauncherView;
import com.zoyi.channel.plugin.android.LauncherConfig;
import com.zoyi.channel.plugin.android.open.enumerate.ChannelButtonPosition;

public class ChannelButtonOption {

  private ChannelButtonPosition position;
  private float xMargin;
  private float yMargin;

  public ChannelButtonOption(ChannelButtonPosition position, float xMargin, float yMargin) {
    this.position = position;
    this.xMargin = xMargin;
    this.yMargin = yMargin;
  }

  public ChannelButtonPosition getPosition() {
    return position;
  }

  public float getXMargin() {
    return xMargin;
  }

  public float getYMargin() {
    return yMargin;
  }

  public int getLauncherGravity() {
    if (ChannelButtonPosition.LEFT.equals(position)) {
      return ChannelLauncherView.BOTTOM_LEFT;
    } else {
      return ChannelLauncherView.BOTTOM_RIGHT;
    }
  }

  @Nullable
  public static ChannelButtonOption fromLegacy(@Nullable LauncherConfig launcherConfig) {
    if (launcherConfig != null && launcherConfig.getPosition() != null) {
      switch (launcherConfig.getPosition()) {
        case LEFT:
          return new ChannelButtonOption(ChannelButtonPosition.LEFT, launcherConfig.getXMargin(), launcherConfig.getYMargin());

        default:
          return new ChannelButtonOption(ChannelButtonPosition.RIGHT, launcherConfig.getXMargin(), launcherConfig.getYMargin());
      }
    }
    return null;
  }
}
