package com.zoyi.channel.plugin.android.activity.profile;

import android.support.annotation.Nullable;
import android.view.View;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.action.UserAction;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.common.navigation.NavigationView;
import com.zoyi.channel.plugin.android.activity.profile.view.BaseEditProfileView;
import com.zoyi.channel.plugin.android.enumerate.ButtonType;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.I18n;
import com.zoyi.channel.plugin.android.model.rest.ProfileBotSchema;
import com.zoyi.channel.plugin.android.selector.ProfileBotSelector;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.view.dialog.ChannelDialog;
import com.zoyi.com.annimon.stream.Optional;

public class EditProfileActivity extends BaseActivity2 {

  private NavigationView navigation;

  @Nullable
  private BaseEditProfileView editProfileView;

  @Nullable
  private String key;

  @Initializer
  @Override
  protected boolean onCreate() {
    init(R.layout.ch_plugin_activity_edit_profile);

    navigation = findViewById(R.id.ch_navigationEditProfile);

    key = getString(Const.EXTRA_PROFILE_KEY);
    ProfileBotSchema schema = ProfileBotSelector.getProfileBotSchemaByKey(key);

    if (key == null || schema == null) {
      return false;
    }

    navigation.setTitle(
        Optional.ofNullable(schema)
            .map(ProfileBotSchema::getNameI18n)
            .map(I18n::get)
            .orElse(ResUtils.getString("ch.settings.my_profile"))
    );
    navigation.addAction(ResUtils.getString("ch.settings.save"), v -> save());

    if (Const.PROFILE_MOBILE_NUMBER_KEY.equals(key)) {
      editProfileView = findViewById(R.id.ch_viewEditProfileMobileNumber);
    } else if (Const.PROFILE_TYPE_BOOLEAN.equals(schema.getType())) {
      editProfileView = findViewById(R.id.ch_viewEditProfileBoolean);
    } else if (Const.PROFILE_TYPE_NUMBER.equals(schema.getType())) {
      editProfileView = findViewById(R.id.ch_viewEditProfileNumber);
    } else if (Const.PROFILE_TYPE_DATE.equals(schema.getType())) {
      editProfileView = findViewById(R.id.ch_viewEditProfileDate);
    } else {
      editProfileView = findViewById(R.id.ch_viewEditProfileString);
    }

    if (editProfileView != null) {
      editProfileView.setVisibility(View.VISIBLE);
      editProfileView.setValue(getString(Const.EXTRA_PROFILE_VALUE));
    }

    return true;
  }

  @Override
  protected void onStart() {
    super.onStart();

    if (editProfileView != null) {
      editProfileView.focus();
    }
  }

  private void save() {
    if (editProfileView != null) {
      if (editProfileView.isValidValue()) {
        updateProfile(editProfileView.getValue());
      } else {
        new ChannelDialog(this)
            .setDescription(ResUtils.getString("ch.profile_form.error"))
            .addButton(ButtonType.OK)
            .show();
      }
    }
  }

  private void updateProfile(@Nullable Object value) {
    showProgress();

    UserAction.updateUserProfile(key, value, () -> {
      hideProgress();
      finish();
    }, (message) -> {
      hideProgress();

      if (message != null) {
        new ChannelDialog(this)
            .setDescription(message)
            .addButton(ButtonType.OK)
            .show();
      }
    });
  }
}
