/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.profile.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.profile.view.BaseEditProfileView;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;

public class EditProfileStringView
extends FrameLayout
implements BaseEditProfileView {
    private WatchedEditText editText;
    private View clearButton;

    public EditProfileStringView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public EditProfileStringView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public EditProfileStringView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @Override
    @Initializer
    public void init(Context context) {
        View root = LayoutInflater.from((Context)context).inflate(R.layout.ch_view_edit_profile_string, (ViewGroup)this, true);
        this.editText = (WatchedEditText)root.findViewById(R.id.ch_editEditProfileString);
        this.clearButton = root.findViewById(R.id.ch_buttonEditProfileStringClearText);
        this.editText.setWatchedTextChangedListener(s -> Views.setVisibility(this.clearButton, !TextUtils.isEmpty((CharSequence)s)));
        this.clearButton.setOnClickListener(v -> this.editText.setText(null));
    }

    @Override
    public void focus() {
        if (this.editText != null) {
            this.editText.requestFocus();
        }
    }

    @Override
    public boolean isValidValue() {
        return true;
    }

    @Override
    @Nullable
    public Object getValue() {
        if (this.editText != null) {
            return this.editText.getString();
        }
        return null;
    }

    @Override
    public void setValue(@Nullable Object value) {
        if (this.editText != null) {
            if (value != null) {
                this.editText.setText((String)value);
            } else {
                this.editText.setText(null);
            }
        }
    }
}

