/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view.viewholder;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnActionButtonClickListener;
import com.zoyi.channel.plugin.android.model.rest.ActionButton;
import com.zoyi.channel.plugin.android.selector.StyleSelector;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.message.MessageParserUtils;
import com.zoyi.channel.plugin.android.view.layout.ChBorderLayout;

public class ActionButtonView
extends FrameLayout
implements View.OnTouchListener {
    private ChBorderLayout borderActionButton;
    private TextView textActionButton;
    private String actionType;
    private ActionButton actionButton;
    @Nullable
    private OnActionButtonClickListener listener;
    private int defaultBackColor = -1;
    private int defaultTextColor;
    private int defaultBorderColor;

    public ActionButtonView(Context context, @NonNull String actionType, @NonNull ActionButton actionButton, @Nullable OnActionButtonClickListener listener) {
        super(context);
        this.actionType = actionType;
        this.actionButton = actionButton;
        this.listener = listener;
        LayoutInflater.from((Context)context).inflate(R.layout.ch_holder_item_action_button, (ViewGroup)this);
        this.borderActionButton = (ChBorderLayout)this.findViewById(R.id.ch_borderActionButton);
        this.textActionButton = (TextView)this.findViewById(R.id.ch_textActionButton);
        this.defaultTextColor = ResUtils.getColor(context, R.color.ch_black_70);
        this.defaultBorderColor = ResUtils.getColor(context, R.color.ch_grey900);
        this.setOnTouchListener(this);
        this.textActionButton.setText((CharSequence)MessageParserUtils.parseText(actionButton.getText()).toString());
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.changeColor(true);
                break;
            }
            case 3: {
                this.changeColor(false);
                break;
            }
            case 1: {
                this.changeColor(false);
                if (this.listener == null) break;
                this.listener.onActionClick(this.actionType, this.actionButton);
            }
        }
        return true;
    }

    private void changeColor(boolean isClicked) {
        this.borderActionButton.setBorderColor(isClicked ? StyleSelector.getBackColor() : this.defaultBorderColor);
        this.borderActionButton.setBackColor(isClicked ? StyleSelector.getBackColor() : this.defaultBackColor);
        this.textActionButton.setTextColor(isClicked ? StyleSelector.getTextColor() : this.defaultTextColor);
    }
}

