package com.zoyi.channel.plugin.android;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;

import com.zoyi.channel.plugin.android.store.InAppPushStore;
import com.zoyi.channel.plugin.android.view.listener.OnPushClickListener;
import com.zoyi.channel.plugin.android.selector.GlobalSelector;
import com.zoyi.channel.plugin.android.selector.InAppPushSelector;
import com.zoyi.channel.plugin.android.store.binder.Binder;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.popup.BubblePushView;
import com.zoyi.channel.plugin.android.view.popup.FullScreenPushView;

/**
 * Control launcher, push
 */
class ChannelView extends FrameLayout implements OnPushClickListener {

  private Context context;

  private ChannelLauncherView launcherView;
  private FullScreenPushView viewPushFullScreen;
  private BubblePushView viewPushBubble;

  @Nullable
  private Binder visibilityBinder;

  @Nullable
  private Binder launcherVisibilityBinder;

  @Nullable
  private Binder popupBinder;

  public ChannelView(Context context) {
    super(context);
    init(context);
  }

  public ChannelView(Context context, AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public ChannelView(Context context, AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  @Initializer
  private void init(Context context) {
    this.context = context;

    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_layout_channel_view, this, true);

    launcherView = view.findViewById(R.id.ch_viewLauncher);

    viewPushBubble = view.findViewById(R.id.ch_viewPushBubble);
    viewPushBubble.setPushClickListener(this);

    viewPushFullScreen = view.findViewById(R.id.ch_viewPushFullScreen);
    viewPushFullScreen.setPushClickListener(this);
  }

  @Override
  protected void onAttachedToWindow() {
    super.onAttachedToWindow();

    visibilityBinder = GlobalSelector.bindBootState(booted -> setVisibility(booted ? View.VISIBLE : View.GONE));

    launcherVisibilityBinder = GlobalSelector.bindLauncherVisibility(showLauncher -> {
      if (showLauncher) {
        launcherView.show();
      } else {
        launcherView.hide();
      }
    });

    popupBinder = InAppPushSelector.bindInAppPush(message -> {
      if (message != null) {
        if (message.getMarketing() != null && message.getMarketing().isFullScreen()) {
          viewPushBubble.resetView();
          viewPushFullScreen.show(message);
        } else {
          viewPushFullScreen.resetView();
          viewPushBubble.show(message);
        }
      } else {
        viewPushFullScreen.resetView();
        viewPushBubble.resetView();
      }
    });
  }

  @Override
  protected void onDetachedFromWindow() {
    super.onDetachedFromWindow();

    if (visibilityBinder != null) {
      visibilityBinder.unbind();
    }

    if (launcherVisibilityBinder != null) {
      launcherVisibilityBinder.unbind();
    }

    if (popupBinder != null) {
      popupBinder.unbind();
    }
  }

  @Override
  public void onPushClick(@NonNull String chatId) {
    InAppPushStore.get().inAppPushMessage.set(null);

    if (context instanceof Activity) {
      ChannelIO.openChat((Activity) context, chatId, null);
    }
  }
}
