/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.operators;

import com.zoyi.rx.Observable;
import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.functions.Func1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperatorTakeUntilPredicate<T>
implements Observable.Operator<T, T> {
    final Func1<? super T, Boolean> stopPredicate;

    public OperatorTakeUntilPredicate(Func1<? super T, Boolean> stopPredicate) {
        this.stopPredicate = stopPredicate;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        final ParentSubscriber parent = new ParentSubscriber(child);
        child.add(parent);
        child.setProducer(new Producer(){

            public void request(long n) {
                parent.downstreamRequest(n);
            }
        });
        return parent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ParentSubscriber
    extends Subscriber<T> {
        private final Subscriber<? super T> child;
        private boolean done;

        ParentSubscriber(Subscriber<? super T> child) {
            this.child = child;
        }

        @Override
        public void onNext(T t) {
            boolean stop;
            this.child.onNext(t);
            try {
                stop = OperatorTakeUntilPredicate.this.stopPredicate.call(t);
            }
            catch (Throwable e) {
                this.done = true;
                Exceptions.throwOrReport(e, this.child, t);
                this.unsubscribe();
                return;
            }
            if (stop) {
                this.done = true;
                this.child.onCompleted();
                this.unsubscribe();
            }
        }

        @Override
        public void onCompleted() {
            if (!this.done) {
                this.child.onCompleted();
            }
        }

        @Override
        public void onError(Throwable e) {
            if (!this.done) {
                this.child.onError(e);
            }
        }

        void downstreamRequest(long n) {
            this.request(n);
        }
    }
}

