package com.zoyi.channel.plugin.android;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.widget.FrameLayout;

import com.zoyi.channel.plugin.android.store.GlobalStore;
import com.zoyi.channel.plugin.android.util.ChannelUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.draw.Display;

public class ActivityInterceptor implements Application.ActivityLifecycleCallbacks {

  @Override
  public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
  }

  @Override
  public void onActivityStarted(Activity activity) {
    L.d("ActivityLifecycle:Started: " + activity.getClass().getSimpleName());

    if (!Display.isLocked()) {
      GlobalStore.get().topActivity.set(activity);

      if (!ChannelUtils.isChannelPluginActivity(activity) && ChannelIO.isAttachChannelView()) {
        FrameLayout root = activity.findViewById(R.id.channel_io_view);
        if (root == null && !activity.getClass().isAnnotationPresent(SkipAttachChannelView.class)) {
          root = new FrameLayout(activity);
          root.setClipChildren(false);
          root.setClipToPadding(false);
          root.setFitsSystemWindows(true);
          root.setId(R.id.channel_io_view);

          try {
            root.addView(new ChannelView(activity));

            activity.addContentView(root, new FrameLayout.LayoutParams(
                FrameLayout.LayoutParams.MATCH_PARENT,
                FrameLayout.LayoutParams.MATCH_PARENT));
          } catch (Exception e) {
            L.e(e.getMessage());
          }
        }
      }
    }
  }

  @Override
  public void onActivityResumed(Activity activity) {
    L.d("ActivityLifecycle:Resumed: " + activity.getClass().getSimpleName());

    if (!Display.isLocked()) {
      GlobalStore.get().topActivity.set(activity);
    }
  }

  @Override
  public void onActivityPaused(Activity activity) {
    L.d("ActivityLifecycle:Paused: " + activity.getClass().getSimpleName());

    if (GlobalStore.get().topActivity.get() == activity) {
      GlobalStore.get().topActivity.set(null);
    }
  }

  @Override
  public void onActivityStopped(Activity activity) {
    L.d("ActivityLifecycle:Stopped: " + activity.getClass().getSimpleName());

    if (GlobalStore.get().topActivity.get() == activity) {
      GlobalStore.get().topActivity.set(null);
    }
  }

  @Override
  public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
  }

  @Override
  public void onActivityDestroyed(Activity activity) {
  }
}
