/*
 * Decompiled with CFR 0.152.
 */
package io.channel.com.google.android.flexbox;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import io.channel.com.google.android.flexbox.FlexLine;
import io.channel.com.google.android.flexbox.FlexboxLayoutManager;
import java.util.List;

public class FlexboxItemDecoration
extends RecyclerView.ItemDecoration {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    public static final int BOTH = 3;
    private static final int[] LIST_DIVIDER_ATTRS = new int[]{16843284};
    private Drawable mDrawable;
    private int mOrientation;

    public FlexboxItemDecoration(Context context) {
        TypedArray a = context.obtainStyledAttributes(LIST_DIVIDER_ATTRS);
        this.mDrawable = a.getDrawable(0);
        a.recycle();
        this.setOrientation(3);
    }

    public void setDrawable(Drawable drawable2) {
        if (drawable2 == null) {
            throw new IllegalArgumentException("Drawable cannot be null.");
        }
        this.mDrawable = drawable2;
    }

    public void setOrientation(int orientation) {
        this.mOrientation = orientation;
    }

    public void onDraw(Canvas canvas, RecyclerView parent, RecyclerView.State state) {
        this.drawHorizontalDecorations(canvas, parent);
        this.drawVerticalDecorations(canvas, parent);
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        int position = parent.getChildAdapterPosition(view);
        if (position == 0) {
            return;
        }
        if (!this.needsHorizontalDecoration() && !this.needsVerticalDecoration()) {
            outRect.set(0, 0, 0, 0);
            return;
        }
        FlexboxLayoutManager layoutManager = (FlexboxLayoutManager)parent.getLayoutManager();
        List<FlexLine> flexLines = layoutManager.getFlexLines();
        int flexDirection = layoutManager.getFlexDirection();
        this.setOffsetAlongMainAxis(outRect, position, layoutManager, flexLines, flexDirection);
        this.setOffsetAlongCrossAxis(outRect, position, layoutManager, flexLines);
    }

    private void setOffsetAlongCrossAxis(Rect outRect, int position, FlexboxLayoutManager layoutManager, List<FlexLine> flexLines) {
        if (flexLines.size() == 0) {
            return;
        }
        int flexLineIndex = layoutManager.getPositionToFlexLineIndex(position);
        if (flexLineIndex == 0) {
            return;
        }
        if (layoutManager.isMainAxisDirectionHorizontal()) {
            if (!this.needsHorizontalDecoration()) {
                outRect.top = 0;
                outRect.bottom = 0;
                return;
            }
            outRect.top = this.mDrawable.getIntrinsicHeight();
            outRect.bottom = 0;
        } else {
            if (!this.needsVerticalDecoration()) {
                return;
            }
            if (layoutManager.isLayoutRtl()) {
                outRect.right = this.mDrawable.getIntrinsicWidth();
                outRect.left = 0;
            } else {
                outRect.left = this.mDrawable.getIntrinsicWidth();
                outRect.right = 0;
            }
        }
    }

    private void setOffsetAlongMainAxis(Rect outRect, int position, FlexboxLayoutManager layoutManager, List<FlexLine> flexLines, int flexDirection) {
        if (this.isFirstItemInLine(position, flexLines, layoutManager)) {
            return;
        }
        if (layoutManager.isMainAxisDirectionHorizontal()) {
            if (!this.needsVerticalDecoration()) {
                outRect.left = 0;
                outRect.right = 0;
                return;
            }
            if (layoutManager.isLayoutRtl()) {
                outRect.right = this.mDrawable.getIntrinsicWidth();
                outRect.left = 0;
            } else {
                outRect.left = this.mDrawable.getIntrinsicWidth();
                outRect.right = 0;
            }
        } else {
            if (!this.needsHorizontalDecoration()) {
                outRect.top = 0;
                outRect.bottom = 0;
                return;
            }
            if (flexDirection == 3) {
                outRect.bottom = this.mDrawable.getIntrinsicHeight();
                outRect.top = 0;
            } else {
                outRect.top = this.mDrawable.getIntrinsicHeight();
                outRect.bottom = 0;
            }
        }
    }

    private void drawVerticalDecorations(Canvas canvas, RecyclerView parent) {
        if (!this.needsVerticalDecoration()) {
            return;
        }
        FlexboxLayoutManager layoutManager = (FlexboxLayoutManager)parent.getLayoutManager();
        int parentTop = parent.getTop() - parent.getPaddingTop();
        int parentBottom = parent.getBottom() + parent.getPaddingBottom();
        int childCount = parent.getChildCount();
        int flexDirection = layoutManager.getFlexDirection();
        for (int i = 0; i < childCount; ++i) {
            int bottom;
            int top;
            int right;
            int left;
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)child.getLayoutParams();
            if (layoutManager.isLayoutRtl()) {
                left = child.getRight() + lp.rightMargin;
                right = left + this.mDrawable.getIntrinsicWidth();
            } else {
                right = child.getLeft() - lp.leftMargin;
                left = right - this.mDrawable.getIntrinsicWidth();
            }
            if (layoutManager.isMainAxisDirectionHorizontal()) {
                top = child.getTop() - lp.topMargin;
                bottom = child.getBottom() + lp.bottomMargin;
            } else if (flexDirection == 3) {
                bottom = child.getBottom() + lp.bottomMargin + this.mDrawable.getIntrinsicHeight();
                bottom = Math.min(bottom, parentBottom);
                top = child.getTop() - lp.topMargin;
            } else {
                top = child.getTop() - lp.topMargin - this.mDrawable.getIntrinsicHeight();
                top = Math.max(top, parentTop);
                bottom = child.getBottom() + lp.bottomMargin;
            }
            this.mDrawable.setBounds(left, top, right, bottom);
            this.mDrawable.draw(canvas);
        }
    }

    private void drawHorizontalDecorations(Canvas canvas, RecyclerView parent) {
        if (!this.needsHorizontalDecoration()) {
            return;
        }
        FlexboxLayoutManager layoutManager = (FlexboxLayoutManager)parent.getLayoutManager();
        int flexDirection = layoutManager.getFlexDirection();
        int parentLeft = parent.getLeft() - parent.getPaddingLeft();
        int parentRight = parent.getRight() + parent.getPaddingRight();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            int left;
            int right;
            int bottom;
            int top;
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)child.getLayoutParams();
            if (flexDirection == 3) {
                top = child.getBottom() + lp.bottomMargin;
                bottom = top + this.mDrawable.getIntrinsicHeight();
            } else {
                bottom = child.getTop() - lp.topMargin;
                top = bottom - this.mDrawable.getIntrinsicHeight();
            }
            if (layoutManager.isMainAxisDirectionHorizontal()) {
                if (layoutManager.isLayoutRtl()) {
                    right = child.getRight() + lp.rightMargin + this.mDrawable.getIntrinsicWidth();
                    right = Math.min(right, parentRight);
                    left = child.getLeft() - lp.leftMargin;
                } else {
                    left = child.getLeft() - lp.leftMargin - this.mDrawable.getIntrinsicWidth();
                    left = Math.max(left, parentLeft);
                    right = child.getRight() + lp.rightMargin;
                }
            } else {
                left = child.getLeft() - lp.leftMargin;
                right = child.getRight() + lp.rightMargin;
            }
            this.mDrawable.setBounds(left, top, right, bottom);
            this.mDrawable.draw(canvas);
        }
    }

    private boolean needsHorizontalDecoration() {
        return (this.mOrientation & 1) > 0;
    }

    private boolean needsVerticalDecoration() {
        return (this.mOrientation & 2) > 0;
    }

    private boolean isFirstItemInLine(int position, List<FlexLine> flexLines, FlexboxLayoutManager layoutManager) {
        int flexLineIndex = layoutManager.getPositionToFlexLineIndex(position);
        if (flexLineIndex != -1 && flexLineIndex < layoutManager.getFlexLinesInternal().size() && layoutManager.getFlexLinesInternal().get((int)flexLineIndex).mFirstIndex == position) {
            return true;
        }
        if (position == 0) {
            return true;
        }
        if (flexLines.size() == 0) {
            return false;
        }
        FlexLine lastLine = flexLines.get(flexLines.size() - 1);
        return lastLine.mLastIndex == position - 1;
    }
}

