package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.media.AudioManager;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Vibrator;
import com.zoyi.channel.plugin.android.R;

public class AlarmCenter {

  public static void alarm(Context context) {
    AudioManager am = (AudioManager) context.getSystemService(Context.AUDIO_SERVICE);

    switch (am.getRingerMode()) {
      case AudioManager.RINGER_MODE_NORMAL:
        sound(context);
        break;

      case AudioManager.RINGER_MODE_VIBRATE:
        vibrate(context);
        break;

      case AudioManager.RINGER_MODE_SILENT:
        break;
    }
  }

  public static void sound(Context context) {
    Uri sound = Uri.parse("android.resource://" + context.getPackageName() + "/" + R.raw.ch_plugin_ringtone);
    Ringtone r = RingtoneManager.getRingtone(context, sound);
    r.play();
  }

  public static void vibrate(Context context) {
    Vibrator v = (Vibrator) context.getSystemService(Context.VIBRATOR_SERVICE);

    if (v.hasVibrator()) {
      v.vibrate(new long[]{0, 500, 110}, -1);
    }
  }
}
