package com.zoyi.channel.plugin.android.activity.language;

import android.app.Dialog;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.language.contract.LanguageSettingsContract;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ProgressHelper;
import com.zoyi.channel.plugin.android.util.ResUtils;

public class LanguageSettingsActivity extends BaseActivity2 implements LanguageSettingsContract.View {

  private LanguageSettingsContract.Presenter presenter;

  @Nullable
  private Dialog dialog;

  @Initializer
  @Override
  protected boolean onCreate() {
    init(R.layout.ch_plugin_activity_language_settings);

    findViewById(R.id.ch_textOptionLanguageKo).setOnClickListener(v -> changeLanguage(CHLocale.KOREAN));
    findViewById(R.id.ch_textOptionLanguageJa).setOnClickListener(v -> changeLanguage(CHLocale.JAPANESE));
    findViewById(R.id.ch_textOptionLanguageEn).setOnClickListener(v -> changeLanguage(CHLocale.ENGLISH));

    presenter = new LanguageSettingsPresenter(this);

    bindPresenter(presenter);

    return true;
  }

  private void changeLanguage(CHLocale locale) {
    presenter.changeLocale(locale);
  }

  @Override
  public void showProgress(CHLocale locale) {
    hideProgress();

    dialog = ProgressHelper.show(
        this,
        ResUtils.getString(this, locale,"ch.settings.changing_message"),
        false
    );
  }

  @Override
  public void hideProgress() {
    if (dialog != null && dialog.isShowing()) {
      dialog.dismiss();
      dialog = null;
    }
  }

  @Override
  public void onLanguageChange(CHLocale locale) {
    finish();
  }
}
