/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view.viewholder;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.Block;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.layout.BorderBackgroundView;
import com.zoyi.channel.plugin.android.view.layout.message.TextMessageView;
import java.util.List;

public abstract class AbsMessageTextView
extends LinearLayout {
    private BorderBackgroundView backHead;
    private BorderBackgroundView backContext;
    private TextMessageView textMessage;
    private TextView textDeleteMessage;

    public AbsMessageTextView(Context context) {
        super(context);
        this.init(context);
    }

    public AbsMessageTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AbsMessageTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(this.getLayoutId(), (ViewGroup)this, true);
        this.backHead = (BorderBackgroundView)view.findViewById(R.id.ch_viewMessageHolderHeadBorder);
        this.backContext = (BorderBackgroundView)view.findViewById(R.id.ch_viewMessageHolderContextBorder);
        this.textMessage = (TextMessageView)view.findViewById(R.id.ch_textMessageHolder);
        this.textDeleteMessage = (TextView)view.findViewById(R.id.ch_textDeleteMessage);
    }

    public void setHead(boolean isHead) {
        Views.setVisibility((View)this.backHead, isHead);
        Views.setVisibility((View)this.backContext, !isHead);
    }

    public void setText(@NonNull CharSequence text) {
        this.textDeleteMessage.setVisibility(8);
        this.textMessage.setVisibility(0);
        this.textMessage.setText(text);
    }

    public void setBlocks(@NonNull List<Block> blocks) {
        this.textDeleteMessage.setVisibility(8);
        this.textMessage.setVisibility(0);
        this.textMessage.setBlocks(blocks);
    }

    public void setDelete() {
        this.textDeleteMessage.setVisibility(0);
        this.textMessage.setVisibility(8);
    }

    protected void setBackColor(int backColor) {
        this.backHead.setColor(backColor);
        this.backContext.setColor(backColor);
        this.textMessage.setBackgroundColor(backColor);
    }

    protected abstract int getLayoutId();
}

