/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.manager;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.rx.Observable;
import com.zoyi.rx.subjects.PublishSubject;
import java.util.HashMap;
import java.util.Map;

public class ChatVideoManager {
    private PublishSubject<String> stopSignalProcessor = PublishSubject.create();
    @Nullable
    private Integer activeContextHashCode;
    @Nullable
    private String activeVideoId;
    private Map<String, Long> videoPositions = new HashMap<String, Long>();
    private Map<String, Boolean> videoVolumeStates = new HashMap<String, Boolean>();
    @Nullable
    private static ChatVideoManager instance;

    public Observable<String> attachStopSignal() {
        return this.stopSignalProcessor.onBackpressureBuffer();
    }

    public void onVideoStarted(Context context, @Nullable String id2) {
        if (!CompareUtils.isSame(id2, this.activeVideoId)) {
            this.stopActiveVideo();
        }
        if (id2 != null) {
            this.activeContextHashCode = context.hashCode();
            this.activeVideoId = id2;
        }
    }

    public void onVideoStopped(Context context, @Nullable String id2) {
        if (this.activeContextHashCode != null && context.hashCode() == this.activeContextHashCode.intValue() && CompareUtils.isSame(id2, this.activeVideoId)) {
            this.reset();
        }
    }

    public void onVideoProgressChanged(@Nullable String id2, Long position) {
        if (this.activeVideoId != null && this.activeVideoId.equals(id2)) {
            this.videoPositions.put(id2, position);
        }
    }

    public void onVideoVolumeStateChanged(@Nullable String id2, boolean isVolumeOn) {
        if (id2 != null) {
            this.videoVolumeStates.put(id2, isVolumeOn);
        }
    }

    @Nullable
    public Long getVideoPosition(@Nullable String id2) {
        return (Long)Optional.ofNullable((Object)id2).map(it -> this.videoPositions.get(it)).orElse(null);
    }

    @Nullable
    public Boolean getVideoVolumeState(@Nullable String id2) {
        return (Boolean)Optional.ofNullable((Object)id2).map(it -> this.videoVolumeStates.get(it)).orElse(null);
    }

    public void onActivityPaused(Activity activity) {
        if (this.activeContextHashCode != null && activity.hashCode() == this.activeContextHashCode.intValue()) {
            this.stopActiveVideo();
            this.reset();
        }
    }

    private void stopActiveVideo() {
        if (this.activeContextHashCode != null && this.activeVideoId != null) {
            this.stopSignalProcessor.onNext((Object)this.activeVideoId);
        }
    }

    private void reset() {
        this.activeContextHashCode = null;
        this.activeVideoId = null;
    }

    public static ChatVideoManager get() {
        if (instance == null) {
            instance = new ChatVideoManager();
        }
        return instance;
    }
}

