/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.rx.internal.producers;

import com.zoyi.rx.Producer;
import com.zoyi.rx.Subscriber;
import com.zoyi.rx.exceptions.Exceptions;
import com.zoyi.rx.internal.operators.BackpressureUtils;
import com.zoyi.rx.internal.util.atomic.SpscLinkedAtomicQueue;
import com.zoyi.rx.internal.util.unsafe.SpscLinkedQueue;
import com.zoyi.rx.internal.util.unsafe.UnsafeAccess;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QueuedValueProducer<T>
extends AtomicLong
implements Producer {
    private static final long serialVersionUID = 7277121710709137047L;
    final Subscriber<? super T> child;
    final Queue<Object> queue;
    final AtomicInteger wip;
    static final Object NULL_SENTINEL = new Object();

    public QueuedValueProducer(Subscriber<? super T> child) {
        this(child, UnsafeAccess.isUnsafeAvailable() ? new SpscLinkedQueue() : new SpscLinkedAtomicQueue());
    }

    public QueuedValueProducer(Subscriber<? super T> child, Queue<Object> queue) {
        this.child = child;
        this.queue = queue;
        this.wip = new AtomicInteger();
    }

    @Override
    public void request(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("n >= 0 required");
        }
        if (n > 0L) {
            BackpressureUtils.getAndAddRequest(this, n);
            this.drain();
        }
    }

    public boolean offer(T value) {
        if (value == null ? !this.queue.offer(NULL_SENTINEL) : !this.queue.offer(value)) {
            return false;
        }
        this.drain();
        return true;
    }

    private void drain() {
        if (this.wip.getAndIncrement() == 0) {
            Subscriber<Object> c = this.child;
            Queue<Object> q = this.queue;
            do {
                Object v;
                if (c.isUnsubscribed()) {
                    return;
                }
                this.wip.lazySet(1);
                long r = this.get();
                long e = 0L;
                while (r != 0L && (v = q.poll()) != null) {
                    try {
                        if (v == NULL_SENTINEL) {
                            c.onNext(null);
                        } else {
                            Object t = v;
                            c.onNext(t);
                        }
                    }
                    catch (Throwable ex) {
                        Exceptions.throwOrReport(ex, c, v != NULL_SENTINEL ? v : null);
                        return;
                    }
                    if (c.isUnsubscribed()) {
                        return;
                    }
                    --r;
                    ++e;
                }
                if (e == 0L || this.get() == Long.MAX_VALUE) continue;
                this.addAndGet(-e);
            } while (this.wip.decrementAndGet() != 0);
        }
    }
}

