/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.com.annimon.stream.function;

import com.zoyi.com.annimon.stream.function.ThrowableIntFunction;

public interface IntFunction<R> {
    public R apply(int var1);

    public static class Util {
        private Util() {
        }

        public static <R> IntFunction<R> safe(ThrowableIntFunction<? extends R, Throwable> throwableFunction) {
            return Util.safe(throwableFunction, null);
        }

        public static <R> IntFunction<R> safe(final ThrowableIntFunction<? extends R, Throwable> throwableFunction, final R resultIfFailed) {
            return new IntFunction<R>(){

                @Override
                public R apply(int value) {
                    try {
                        return throwableFunction.apply(value);
                    }
                    catch (Throwable throwable) {
                        return resultIfFailed;
                    }
                }
            };
        }
    }
}

