package com.zoyi.channel.plugin.android.util;

import android.support.annotation.Nullable;

/**
 * Created by mika on 2016. 3. 21..
 */
public class CompareUtils {
  public static boolean equals(@Nullable String s1, @Nullable String s2) {
    if (s1 == null && s2 == null) {
      return true;
    } else if (s1 == null || s2 == null) {
      return false;
    }
    return s1.equals(s2);
  }

  public static boolean isSame(String s1, String s2) {
    return compare(s1, s2) == 0;
  }

  public static int compare(String s1, String s2) {
    if (s1 == null && s2 == null) { return 0; }
    if (s1 == null) { return 1; }
    if (s2 == null) { return -1; }

    return s1.compareTo(s2);
  }

  public static int compare(Long lhs, Long rhs) {
    if (lhs == null && rhs == null) {
      return 0;
    }
    if (lhs == null) {
      return -1;
    }
    if (rhs == null) {
      return 1;
    }

    return Long.compare(lhs, rhs);
  }

  /**
   * Compares target to the specified values.
   *
   * @param  target
   *         The target to compare, null allows.
   *
   * @param  values
   *         values to compare
   *
   * @return  return boolean if target is exists in values.
   */
  @SafeVarargs
  public static <E extends Comparable> boolean exists(E target, E... values) {
    for (E ee : values) {
      if (ee == null) {
        if (target == null) { return true; }
      } else if (ee.equals(target)) {
        return true;
      }
    }
    return false;
  }

  private static int asciiCase(char ch) {
    return ch < 128 ? 1 : 0;
  }

  private static char foldCase(char ch) {
    if (ch < 128) {
      if ('A' <= ch && ch <= 'Z') {
        return (char) (ch + ('a' - 'A'));
      }
      return ch;
    }
    return Character.toLowerCase(Character.toUpperCase(ch));
  }
}

