package com.zoyi.channel.plugin.android.view.youtube.player.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class Utils {

  public static boolean isOnline(Context context) {
    ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
    NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
    return networkInfo != null && networkInfo.isConnected();
  }

  public static String readHTMLFromUTF8File(InputStream inputStream) throws IOException {
    try {
      BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));

      String currentLine = bufferedReader.readLine();
      StringBuilder sb = new StringBuilder();

      while (currentLine != null) {
        sb.append(currentLine).append("\n");
        currentLine = bufferedReader.readLine();
      }

      return sb.toString();
    } catch (Exception e) {
      throw new RuntimeException("Can't parse HTML file.");
    } finally {
      inputStream.close();
    }
  }
}