package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.com.annimon.stream.Optional;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by jerry on 2018. 3. 27..
 */

public class AssetUtils {

  private static final String EMOJI_FILE = "emojis.min.json";
  private static final String EXTENSIONS_FILE = "extensions.json";

  private static Map<String, String> emojiMap;
  private static Map<String, String> extensionMap;

  private static final String KEY_EMOJI_NAME = "n";
  private static final String KEY_EMOJI_CONTENT = "c";

  private static final String KEY_EXTENSION_KEY = "key";
  private static final String KEY_EXTENSION_LIST = "extensions";

  private static final String DEFAULT_FILE_KEY = "file";

  public static String getEmoji(Context context, String key) {
    if (emojiMap != null) {
      return emojiMap.get(key);
    }

    emojiMap = new ConcurrentHashMap<>();

    try {
      InputStream inputStream = context.getAssets().open(EMOJI_FILE);
      int size = inputStream.available();
      byte[] buffer = new byte[size];

      inputStream.read(buffer);
      inputStream.close();

      JSONObject emojiJson = new JSONObject(new String(buffer, "UTF-8"));

      Iterator<String> emojiKeys = emojiJson.keys();
      while (emojiKeys.hasNext()) {
        String category = emojiKeys.next();

        JSONArray emojiCategory = emojiJson.getJSONArray(category);

        for (int i = 0; i < emojiCategory.length(); i++) {
          String emojiKey = emojiCategory.getJSONObject(i).getString(KEY_EMOJI_NAME);
          String emojiValue = emojiCategory.getJSONObject(i).getString(KEY_EMOJI_CONTENT);

          if (emojiKey != null && emojiValue != null) {
            emojiMap.put(emojiKey, emojiValue);
          }
        }
      }

    } catch (Exception ignored) {
    }

    return emojiMap.get(key);
  }

  @NonNull
  public static String getIconUrl(Context context, @Nullable String extension) {
    if (extensionMap == null) {
      extensionMap = new HashMap<>();

      try {
        InputStream inputStream = context.getAssets().open(EXTENSIONS_FILE);
        int size = inputStream.available();
        byte[] buffer = new byte[size];

        inputStream.read(buffer);
        inputStream.close();

        JSONArray extensionList = new JSONArray(new String(buffer, "UTF-8"));

        for (int i = 0; i < extensionList.length(); i++) {
          JSONObject extensionData = extensionList.getJSONObject(i);
          String extensionKey = extensionData.getString(KEY_EXTENSION_KEY);
          JSONArray extensionArray = extensionData.getJSONArray(KEY_EXTENSION_LIST);

          for (int j = 0; j < extensionArray.length(); j++) {
            extensionMap.put(extensionArray.getString(j), extensionKey);
          }
        }
      } catch (Exception ignored) {
      }
    }

    String iconPath = String.format(
        Const.FILE_ICON_PATH,
        Optional.ofNullable(extensionMap)
            .map(map -> map.get(extension))
            .filter(it -> !it.isEmpty())
            .orElse(DEFAULT_FILE_KEY)
    );

    return String.format("%s/%s", UriUtils.getCloudFrontUrl(), iconPath);
  }
}
