/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.model.rest;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.store.GlobalStore;
import com.zoyi.channel.plugin.android.util.draw.Display;
import com.zoyi.com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;

public class Event {
    private String name;
    private Map<String, Object> property;

    public Event(@NonNull String name, @Nullable Map<String, Object> property) {
        this.name = name;
        this.property = property;
        this.initProperty();
    }

    private void initProperty() {
        Context context;
        Activity topActivity;
        if (this.property == null) {
            this.property = new HashMap<String, Object>();
        }
        if (!this.property.containsKey("pluginVersion") || this.property.get("url") != null) {
            this.property.put("pluginVersion", "7.0.7-beta4");
        }
        if (!(this.property.containsKey("url") && this.property.get("url") == null || (topActivity = GlobalStore.get().topActivity.get()) == null)) {
            this.property.put("url", topActivity.getClass().getSimpleName());
        }
        if ((context = ChannelIO.getAppContext()) != null) {
            this.property.put("screenWidth", Display.getWidth(context));
            this.property.put("screenHeight", Display.getHeight(context));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPropertyToJson() {
        return new Gson().toJson(this.property);
    }
}

