package com.zoyi.channel.plugin.android.store;

import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.LauncherConfig;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.store.base.Store;
import com.zoyi.channel.plugin.android.store.state.BooleanState;
import com.zoyi.channel.plugin.android.store.state.EnumState;
import com.zoyi.channel.plugin.android.store.state.State;

public class SettingsStore extends Store {

  public BooleanState showLauncher = new BooleanState(false);

  public EnumState<CHLocale> locale = new EnumState<>(CHLocale.ENGLISH);

  public BooleanState showTranslation = new BooleanState(true);

  public BooleanState showClosedChat = new BooleanState(false);

  public BooleanState raiseSoundVibrate = new BooleanState(true);

  public BooleanState enabledTrackDefaultEvent = new BooleanState(Const.DEFAULT_SETTINGS_ENABLED_TRACK_DEFAULT_EVENT);

  public BooleanState hideDefaultInAppPush = new BooleanState(Const.DEFAULT_SETTINGS_HIDE_DEFAULT_IN_APP_PUSH);

  public State<LauncherConfig> launcherConfig = new State<>();

  @Override
  protected void reset() {
    locale.reset();
    showTranslation.reset();
    showClosedChat.reset();
    raiseSoundVibrate.reset();
    enabledTrackDefaultEvent.reset();
    hideDefaultInAppPush.reset();
    launcherConfig.reset();
  }

  public static SettingsStore get() {
    return Store.getInstance(SettingsStore.class);
  }
}
