package com.zoyi.channel.plugin.android.activity.chat.view.attachment;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnAttachmentContentActionListener;
import com.zoyi.channel.plugin.android.activity.chat.view.viewholder.MessageContentView;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.File;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.view.media_thumbnail.FileAttachmentView;
import com.zoyi.channel.plugin.android.view.media_thumbnail.MediaThumbnailView;
import com.zoyi.channel.plugin.android.view.media_thumbnail.OriginAttachmentMediaThumbnailView;
import com.zoyi.com.annimon.stream.Stream;

import java.util.List;

public class AttachmentGroupLinearLayout extends LinearLayout implements MessageContentView {

  private Context context;

  public AttachmentGroupLinearLayout(Context context) {
    super(context);

    init(context);
  }

  public AttachmentGroupLinearLayout(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init(context);
  }

  public AttachmentGroupLinearLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);

    init(context);
  }

  private void init(Context context) {
    this.context = context;

    setOrientation(VERTICAL);
  }

  public void setAttachments(
      @Nullable String messageId,
      List<File> files,
      @Nullable OnAttachmentContentActionListener listener
  ) {
    clear();

    Stream.ofNullable(files).forEach(file -> {
      switch (file.getType()) {
        case Const.FILE_TYPE_VIDEO:
        case Const.FILE_TYPE_IMAGE:
          OriginAttachmentMediaThumbnailView view = new OriginAttachmentMediaThumbnailView(context);
          view.setAttachment(messageId, file, listener);

          addView(view, -1, getChildLayoutParam());
          break;

        default:
          FileAttachmentView fileView = new FileAttachmentView(context);
          fileView.setAttachment(file, listener);

          addView(fileView, -1, getChildLayoutParam());
          break;
      }
    });
  }

  private LayoutParams getChildLayoutParam() {
    LayoutParams params = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
    int margin = ResUtils.getDimen(context, R.dimen.ch_chat_message_attachment_margin) / 2;

    params.setMargins(margin, margin, margin, margin);

    return params;
  }

  @Override
  public void resetView() {
    if (getChildCount() > 0) {
      clear();
      removeAllViews();
    }
  }

  @Override
  public void clear() {
    if (getChildCount() > 0) {
      for (int i = 0; i < getChildCount(); i++) {
        View view = getChildAt(i);

        if (view instanceof MediaThumbnailView) {
          ((MediaThumbnailView) view).clear();
        }
        if (view instanceof FileAttachmentView) {
          ((FileAttachmentView) view).clear();
        }
      }
    }
  }
}
