/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.selector;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.UserChatItem;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Bot;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Session;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.store.BotStore;
import com.zoyi.channel.plugin.android.store.ChannelStore;
import com.zoyi.channel.plugin.android.store.ManagerStore;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.channel.plugin.android.store.UserChatStore;
import com.zoyi.channel.plugin.android.store.binder.Binder;
import com.zoyi.channel.plugin.android.store.binder.Binder1;
import com.zoyi.channel.plugin.android.store.binder.Binder3;
import com.zoyi.channel.plugin.android.store.binder.Binder7;
import com.zoyi.channel.plugin.android.store.state.BooleanState;
import com.zoyi.channel.plugin.android.store.state.EntityMapState;
import com.zoyi.channel.plugin.android.store.state.EnumState;
import com.zoyi.channel.plugin.android.store.state.State;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Action2;
import com.zoyi.rx.functions.Action3;
import com.zoyi.rx.functions.Action7;
import java.util.ArrayList;
import java.util.List;

public class ChatsSelector {
    public static Binder bindUserChatsMore(Action2<Boolean, Integer> action2) {
        State<String> nextChatState = UserChatStore.get().next;
        EntityMapState<UserChat> userChatsState = UserChatStore.get().userChats;
        EnumState<CHLocale> localeState = SettingsStore.get().locale;
        return new Binder3<String, UserChat, CHLocale>(nextChatState, userChatsState, localeState).bind((Action3<String, UserChat, CHLocale>)((Action3)(next, userChats, locale) -> {
            int visibleChatsCount = 0;
            int invisibleChatsCount = 0;
            if (userChats != null) {
                for (UserChat userChat : userChats.values()) {
                    if (!userChat.isStateClosed() && !userChat.isStateRemoved()) {
                        if (visibleChatsCount < 3) {
                            ++visibleChatsCount;
                            continue;
                        }
                        ++invisibleChatsCount;
                        continue;
                    }
                    if (!userChat.isStateClosed()) continue;
                    ++invisibleChatsCount;
                }
            }
            action2.call((Object)(next != null && !next.isEmpty() || invisibleChatsCount > 99 ? 1 : 0), (Object)Math.min(invisibleChatsCount, 99));
        }));
    }

    public static Binder bindChats(Action2<List<ChatItem>, List<ChatItem>> action2) {
        EntityMapState<UserChat> userChatsState = UserChatStore.get().userChats;
        EntityMapState<Session> sessionsState = UserChatStore.get().sessions;
        EntityMapState<Message> messagesState = UserChatStore.get().messages;
        EntityMapState<Manager> managersState = ManagerStore.get().managers;
        EntityMapState<Bot> botsState = BotStore.get().bots;
        State<String> defaultBotIdState = BotStore.get().defaultBotId;
        BooleanState showClosedChatsState = SettingsStore.get().showClosedChat;
        return new Binder7<UserChat, Session, Message, Manager, Bot, String, Boolean>(userChatsState, sessionsState, messagesState, managersState, botsState, defaultBotIdState, showClosedChatsState).bind((Action7<UserChat, Session, Message, Manager, Bot, String, Boolean>)((Action7)(userChats, sessions, messages, managers, bots, defaultBotId, showClosedChat) -> {
            ArrayList<UserChatItem> activeChatItems = new ArrayList<UserChatItem>();
            ArrayList<UserChatItem> closedChatItems = new ArrayList<UserChatItem>();
            for (UserChat userChat : userChats.values()) {
                if (userChat.isStateRemoved()) continue;
                Message message = (Message)messages.get(userChat.getId());
                Session session = (Session)sessions.get(userChat.getId());
                ProfileEntity profileEntity = null;
                if (userChat.getAssigneeId() != null) {
                    profileEntity = (ProfileEntity)managers.get(userChat.getAssigneeId());
                }
                if (profileEntity == null && defaultBotId != null) {
                    profileEntity = (ProfileEntity)bots.get(defaultBotId);
                }
                UserChatItem newChatItem = new UserChatItem(userChat, message, session, profileEntity);
                if (showClosedChat.booleanValue() && userChat.isStateClosed()) {
                    closedChatItems.add(newChatItem);
                    continue;
                }
                if (userChat.isStateClosed()) continue;
                activeChatItems.add(newChatItem);
            }
            action2.call(activeChatItems, closedChatItems);
        }));
    }

    public static Binder bindUserChatsFetchState(Action1<FetchState> action1) {
        return new Binder1<FetchState>(UserChatStore.get().userChatsFetchState).bind(action1);
    }

    public static Binder binderHost(@Nullable String chatId, Action1<ProfileEntity> action1) {
        EntityMapState<UserChat> userChatsState = UserChatStore.get().userChats;
        EntityMapState<Manager> managersState = ManagerStore.get().managers;
        State<Channel> channelState = ChannelStore.get().channelState;
        return new Binder3<UserChat, Manager, Channel>(userChatsState, managersState, channelState).bind((Action3<UserChat, Manager, Channel>)((Action3)(userChats, managers, channel) -> {
            Manager manager;
            UserChat userChat;
            UserChat userChat2 = userChat = chatId != null ? (UserChat)userChats.get(chatId) : null;
            if (userChat == null) {
                action1.call(channel);
                return;
            }
            Manager manager2 = manager = userChat.getAssigneeId() != null ? (Manager)managers.get(userChat.getAssigneeId()) : null;
            if (manager != null) {
                action1.call((Object)manager);
            } else {
                action1.call(channel);
            }
        }));
    }
}

