/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.com.bumptech.glide.load.model;

import android.net.Uri;
import android.text.TextUtils;
import com.zoyi.com.bumptech.glide.load.model.Headers;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public class GlideUrl {
    private static final String ALLOWED_URI_CHARS = "@#&=*+-_.,:!?()/~'%";
    private final URL url;
    private final Headers headers;
    private final String stringUrl;
    private String safeStringUrl;
    private URL safeUrl;

    public GlideUrl(URL url) {
        this(url, Headers.DEFAULT);
    }

    public GlideUrl(String url) {
        this(url, Headers.DEFAULT);
    }

    public GlideUrl(URL url, Headers headers) {
        if (url == null) {
            throw new IllegalArgumentException("URL must not be null!");
        }
        if (headers == null) {
            throw new IllegalArgumentException("Headers must not be null");
        }
        this.url = url;
        this.stringUrl = null;
        this.headers = headers;
    }

    public GlideUrl(String url, Headers headers) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            throw new IllegalArgumentException("String url must not be empty or null: " + url);
        }
        if (headers == null) {
            throw new IllegalArgumentException("Headers must not be null");
        }
        this.stringUrl = url;
        this.url = null;
        this.headers = headers;
    }

    public URL toURL() throws MalformedURLException {
        return this.getSafeUrl();
    }

    private URL getSafeUrl() throws MalformedURLException {
        if (this.safeUrl == null) {
            this.safeUrl = new URL(this.getSafeStringUrl());
        }
        return this.safeUrl;
    }

    public String toStringUrl() {
        return this.getSafeStringUrl();
    }

    private String getSafeStringUrl() {
        if (TextUtils.isEmpty((CharSequence)this.safeStringUrl)) {
            String unsafeStringUrl = this.stringUrl;
            if (TextUtils.isEmpty((CharSequence)unsafeStringUrl)) {
                unsafeStringUrl = this.url.toString();
            }
            this.safeStringUrl = Uri.encode((String)unsafeStringUrl, (String)ALLOWED_URI_CHARS);
        }
        return this.safeStringUrl;
    }

    public Map<String, String> getHeaders() {
        return this.headers.getHeaders();
    }

    public String getCacheKey() {
        return this.stringUrl != null ? this.stringUrl : this.url.toString();
    }

    public String toString() {
        return this.getCacheKey() + '\n' + this.headers.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof GlideUrl) {
            GlideUrl other = (GlideUrl)o;
            return this.getCacheKey().equals(other.getCacheKey()) && this.headers.equals(other.headers);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.getCacheKey().hashCode();
        hashCode = 31 * hashCode + this.headers.hashCode();
        return hashCode;
    }
}

